/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class BoundaryConstraint
extends Constraint {
    public BoundaryConstraint(double low, double high) {
        this.impl = new Impl(low, high);
    }

    private class Impl
    extends Constraint.Impl {
        private final double low;
        private final double high;

        private Impl(double low, double high) {
            super(BoundaryConstraint.this);
            this.low = low;
            this.high = high;
        }

        @Override
        public boolean test(Array params) {
            for (int i = 0; i < params.size(); ++i) {
                if (!(params.get(i) < this.low) && !(params.get(i) > this.high)) continue;
                return false;
            }
            return true;
        }
    }
}

