/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities.internal;

import java.util.EnumSet;
import java.util.Set;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.math.matrixutilities.internal.DirectMatrixAddress;
import org.jquantlib.math.matrixutilities.internal.MappedAddress;

public class MappedMatrixAddress
extends MappedAddress
implements Address.MatrixAddress {
    public MappedMatrixAddress(double[] data, int[] ridx, Address.MatrixAddress chain, int col0, int col1, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        super(data, ridx, chain, col0, col1, flags, contiguous, rows, cols);
    }

    public MappedMatrixAddress(double[] data, int row0, int row1, Address.MatrixAddress chain, int[] cidx, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        super(data, row0, row1, chain, cidx, flags, contiguous, rows, cols);
    }

    public MappedMatrixAddress(double[] data, int[] ridx, Address.MatrixAddress chain, int[] cidx, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        super(data, ridx, chain, cidx, flags, contiguous, rows, cols);
    }

    @Override
    public Address.MatrixAddress toFortran() {
        return this.isFortran() ? this : new DirectMatrixAddress(this.data, this.row0, this.row1, this.chain, this.col0, this.col1, EnumSet.of(Address.Flags.FORTRAN), this.contiguous, this.rows, this.cols);
    }

    @Override
    public Address.MatrixAddress toJava() {
        return this.isFortran() ? new DirectMatrixAddress(this.data, this.row0 + 1, this.row1 + 1, this.chain, this.col0 + 1, this.col1 + 1, EnumSet.noneOf(Address.Flags.class), this.contiguous, this.rows, this.cols) : this;
    }

    @Override
    public Address.MatrixAddress.MatrixOffset offset() {
        return new FastMatrixIndexAddressOffset(0, 0);
    }

    @Override
    public Address.MatrixAddress.MatrixOffset offset(int row, int col) {
        return new FastMatrixIndexAddressOffset(row, col);
    }

    @Override
    public int op(int row, int col) {
        return (this.row0 + this.ridx[row]) * this.cols + (this.col0 + this.cidx[col]);
    }

    @Override
    public MappedMatrixAddress clone() {
        try {
            return (MappedMatrixAddress)super.clone();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    private class FastMatrixIndexAddressOffset
    extends MappedAddress.FastIndexAddressOffset
    implements Address.MatrixAddress.MatrixOffset {
        public FastMatrixIndexAddressOffset(int row, int col) {
            this.row = MappedMatrixAddress.this.row0 + row;
            this.col = MappedMatrixAddress.this.col0 + col;
        }

        @Override
        public void nextRow() {
            ++this.row;
        }

        @Override
        public void nextCol() {
            ++this.col;
        }

        @Override
        public void prevRow() {
            --this.row;
        }

        @Override
        public void prevCol() {
            --this.col;
        }

        @Override
        public void setRow(int row) {
            this.row = MappedMatrixAddress.this.row0 + row;
        }

        @Override
        public void setCol(int col) {
            this.col = MappedMatrixAddress.this.col0 + col;
        }

        @Override
        public int op() {
            return MappedMatrixAddress.this.ridx[this.row] * MappedMatrixAddress.this.cols + MappedMatrixAddress.this.cidx[this.col];
        }
    }
}

