/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities.internal;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.internal.Address;

public abstract class MappedAddress
implements Address {
    protected final double[] data;
    protected final int row0;
    protected final int row1;
    protected final Address chain;
    protected final int col0;
    protected final int col1;
    protected final Set<Address.Flags> flags;
    protected final boolean contiguous;
    protected final int rows;
    protected final int cols;
    protected final int offset;
    protected final int[] ridx;
    protected final int[] cidx;
    private final int base;
    private final int last;

    public MappedAddress(double[] data, int row0, int row1, Address chain, int[] cidx, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        this(data, MappedAddress.makeIndex(row0, row1), chain, cidx, flags, contiguous, rows, cols);
    }

    public MappedAddress(double[] data, int[] ridx, Address chain, int col0, int col1, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        this(data, ridx, chain, MappedAddress.makeIndex(col0, col1), flags, contiguous, rows, cols);
    }

    public MappedAddress(double[] data, int[] ridx, Address chain, int[] cidx, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        this.data = data;
        this.chain = chain;
        this.offset = this.isFortran() ? 1 : 0;
        boolean contiguous_ = contiguous & (chain == null || chain.isContiguous());
        this.ridx = (int[])ridx.clone();
        int i = 0;
        while (i < this.ridx.length) {
            int n = i++;
            this.ridx[n] = this.ridx[n] + this.offset;
        }
        int[] rorder = (int[])this.ridx.clone();
        Arrays.sort(rorder);
        int row0 = rorder[0];
        int row1 = rorder[rorder.length - 1];
        contiguous_ &= MappedAddress.contiguous(rorder);
        this.cidx = (int[])cidx.clone();
        int i2 = 0;
        while (i2 < this.cidx.length) {
            int n = i2++;
            this.cidx[n] = this.cidx[n] + this.offset;
        }
        int[] corder = (int[])this.cidx.clone();
        Arrays.sort(corder);
        int col0 = corder[0];
        int col1 = corder[corder.length - 1];
        this.contiguous = contiguous_ &= MappedAddress.contiguous(corder);
        Set<Address.Flags> set = flags != null ? flags : (this.flags = chain != null ? chain.flags() : EnumSet.noneOf(Address.Flags.class));
        if (chain == null) {
            this.row0 = row0;
            this.col0 = col0;
        } else {
            this.row0 = row0 + chain.row0() - (chain.isFortran() ? 1 : 0);
            this.col0 = col0 + chain.col0() - (chain.isFortran() ? 1 : 0);
        }
        this.row1 = this.row0 + (row1 - row0);
        this.col1 = this.col0 + (col1 - col0);
        this.rows = chain == null ? rows : chain.rows();
        this.cols = chain == null ? cols : chain.cols();
        this.base = (row0 + this.offset) * cols + (col0 + this.offset);
        this.last = (row1 + this.offset) * cols + (col1 + this.offset);
    }

    public MappedAddress clone() {
        try {
            return (MappedAddress)super.clone();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    @Override
    public boolean isContiguous() {
        return this.contiguous;
    }

    @Override
    public boolean isFortran() {
        return this.flags != null && this.flags.contains((Object)Address.Flags.FORTRAN);
    }

    @Override
    public Set<Address.Flags> flags() {
        return this.flags;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int row0() {
        return this.row0;
    }

    @Override
    public int col0() {
        return this.col0;
    }

    @Override
    public int base() {
        return this.base;
    }

    @Override
    public int last() {
        return this.last;
    }

    private static final int[] makeIndex(int idx0, int idx1) {
        int[] result = new int[idx1 - idx0 + 1];
        for (int i = idx0; i <= idx1; ++i) {
            result[i] = i;
        }
        return result;
    }

    private static boolean contiguous(int[] array) {
        int[] rorder = (int[])array.clone();
        Arrays.sort(rorder);
        boolean result = false;
        int curr = rorder[0];
        for (int element : rorder) {
            boolean bl = result = element == curr;
            if (!result) break;
            ++curr;
        }
        return result;
    }

    protected abstract class FastIndexAddressOffset
    implements Address.Offset {
        protected int row;
        protected int col;

        protected FastIndexAddressOffset() {
        }
    }
}

