/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities.internal;

import java.util.EnumSet;
import java.util.Set;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.internal.Address;

public abstract class DirectAddress
implements Address,
Cloneable {
    protected final double[] data;
    protected final int row0;
    protected final int row1;
    protected final Address chain;
    protected final int col0;
    protected final int col1;
    protected final Set<Address.Flags> flags;
    protected final boolean contiguous;
    protected final int rows;
    protected final int cols;
    protected final int offset;
    private final int base;
    private final int last;

    public DirectAddress(double[] data, int row0, int row1, Address chain, int col0, int col1, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        this.data = data;
        this.chain = chain;
        this.contiguous = contiguous;
        this.flags = flags != null ? flags : (chain != null ? chain.flags() : EnumSet.noneOf(Address.Flags.class));
        this.offset = this.isFortran() ? 1 : 0;
        this.row0 = row0 - this.offset + (chain == null ? 0 : chain.row0());
        this.col0 = col0 - this.offset + (chain == null ? 0 : chain.col0());
        this.row1 = this.row0 + (row1 - row0);
        this.col1 = this.col0 + (col1 - col0);
        this.rows = chain == null ? rows : chain.rows();
        this.cols = chain == null ? cols : chain.cols();
        this.base = (row0 - this.offset) * cols + (col0 - this.offset);
        this.last = (row1 - this.offset - 1) * cols + (col1 - this.offset - 1);
    }

    @Override
    public boolean isContiguous() {
        return this.contiguous;
    }

    @Override
    public boolean isFortran() {
        return this.flags.contains((Object)Address.Flags.FORTRAN);
    }

    @Override
    public Set<Address.Flags> flags() {
        return this.flags;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int row0() {
        return this.row0;
    }

    @Override
    public int col0() {
        return this.col0;
    }

    @Override
    public int base() {
        return this.base;
    }

    @Override
    public int last() {
        return this.last;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[row0=").append(this.row0).append(" row1=").append(this.row1);
        sb.append(" col0=").append(this.col0).append(" col1=").append(this.col1);
        sb.append(" flags=").append(this.flags).append("]");
        return sb.toString();
    }

    public DirectAddress clone() {
        try {
            return (DirectAddress)super.clone();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    protected abstract class DirectAddressOffset
    implements Address.Offset {
        protected int row;
        protected int col;

        protected DirectAddressOffset() {
        }
    }
}

