/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.optimization.CostFunction;

class HypersphereCostFunction
extends CostFunction {
    private final int size_;
    private final boolean lowerDiagonal_;
    private final Matrix targetMatrix_;
    private final Array targetVariance_;
    private final Matrix currentRoot_;
    private Matrix tempMatrix_;
    private Matrix currentMatrix_;

    public HypersphereCostFunction(Matrix targetMatrix, Array targetVariance, boolean lowerDiagonal) {
        this.size_ = targetMatrix.rows;
        this.lowerDiagonal_ = lowerDiagonal;
        this.targetMatrix_ = targetMatrix;
        this.targetVariance_ = targetVariance;
        this.currentRoot_ = new Matrix(this.size_, this.size_);
        this.tempMatrix_ = new Matrix(this.size_, this.size_);
        this.currentMatrix_ = new Matrix(this.size_, this.size_);
    }

    @Override
    public Array values(Array array) {
        throw new UnsupportedOperationException("values method not implemented");
    }

    @Override
    public double value(Array x) {
        int j;
        int k;
        int i;
        this.currentRoot_.fill(1.0);
        if (this.lowerDiagonal_) {
            for (i = 0; i < this.size_; ++i) {
                for (k = 0; k < this.size_; ++k) {
                    if (k > i) {
                        this.currentRoot_.set(i, k, 0.0);
                        continue;
                    }
                    for (j = 0; j <= k; ++j) {
                        if (j == k && k != i) {
                            this.currentRoot_.set(i, k, this.currentMatrix_.get(i, k) * Math.cos(x.get(i * (i - 1) / 2 + j)));
                            continue;
                        }
                        if (j == i) continue;
                        this.currentRoot_.set(i, k, this.currentRoot_.get(i, k) * Math.sin(x.get(i * (i - 1) / 2 + j)));
                    }
                }
            }
        } else {
            for (i = 0; i < this.size_; ++i) {
                for (k = 0; k < this.size_; ++k) {
                    for (j = 0; j <= k; ++j) {
                        if (j == k && k != this.size_ - 1) {
                            this.currentRoot_.set(i, k, this.currentRoot_.get(i, k) * Math.cos(x.get(j * this.size_ + i)));
                            continue;
                        }
                        if (j == this.size_ - 1) continue;
                        this.currentRoot_.set(i, k, this.currentRoot_.get(i, j) * Math.sin(x.get(j * this.size_ + i)));
                    }
                }
            }
        }
        double error = 0.0;
        this.tempMatrix_ = this.currentRoot_.transpose();
        this.currentMatrix_ = this.currentRoot_.mul(this.tempMatrix_);
        for (i = 0; i < this.size_; ++i) {
            for (j = 0; j < this.size_; ++j) {
                double temp = this.currentMatrix_.get(i, j) * this.targetVariance_.get(i) * this.targetVariance_.get(j) - this.targetMatrix_.get(i, j);
                error += temp * temp;
            }
        }
        return error;
    }
}

