/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.internal.Address;

@QualityAssurance(quality=QualityAssurance.Quality.Q1_TRANSLATION, version=QualityAssurance.Version.OTHER, reviewers={"Richard Gomes"})
public class EigenvalueDecomposition {
    private final int n;
    private boolean issymmetric;
    private final double[] d;
    private final double[] e;
    private final Matrix V;
    private Matrix H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;

    public EigenvalueDecomposition(Matrix A) {
        int i;
        QL.require(A.rows() == A.cols(), "matrix must be square");
        this.n = A.cols();
        this.V = new Matrix(this.n, this.n);
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = true;
        int j = 0;
        while (j < this.n & this.issymmetric) {
            i = 0;
            while (i < this.n & this.issymmetric) {
                this.issymmetric = A.$[((Address.MatrixAddress)A.addr).op(i, j)] == A.$[((Address.MatrixAddress)A.addr).op(j, i)];
                ++i;
            }
            ++j;
        }
        if (this.issymmetric) {
            for (int i2 = 0; i2 < this.n; ++i2) {
                for (int j2 = 0; j2 < this.n; ++j2) {
                    this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i2, (int)j2)] = A.$[((Address.MatrixAddress)A.addr).op(i2, j2)];
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new Matrix(this.n, this.n);
            this.ort = new double[this.n];
            for (j = 0; j < this.n; ++j) {
                for (i = 0; i < this.n; ++i) {
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)j)] = A.$[((Address.MatrixAddress)A.addr).op(i, j)];
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    public Matrix getV() {
        return this.V.clone();
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public Matrix getD() {
        Matrix D = new Matrix(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                D.$[((Address.MatrixAddress)D.addr).op((int)i, (int)j)] = 0.0;
            }
            D.$[((Address.MatrixAddress)D.addr).op((int)i, (int)i)] = this.d[i];
            if (this.e[i] > 0.0) {
                D.$[((Address.MatrixAddress)D.addr).op((int)i, (int)(i + 1))] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D.$[((Address.MatrixAddress)D.addr).op((int)i, (int)(i - 1))] = this.e[i];
        }
        return D;
    }

    private void tred2() {
        int i;
        int j;
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V.$[((Address.MatrixAddress)this.V.addr).op(this.n - 1, j)];
        }
        for (i = this.n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(this.d[k]);
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    this.d[j2] = this.V.$[((Address.MatrixAddress)this.V.addr).op(i - 1, j2)];
                    this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i, (int)j2)] = 0.0;
                    this.V.$[((Address.MatrixAddress)this.V.addr).op((int)j2, (int)i)] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                for (j4 = 0; j4 < i; ++j4) {
                    this.e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    this.V.$[((Address.MatrixAddress)this.V.addr).op((int)j4, (int)i)] = f = this.d[j4];
                    g = this.e[j4] + this.V.$[((Address.MatrixAddress)this.V.addr).op(j4, j4)] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += this.V.$[((Address.MatrixAddress)this.V.addr).op(k2, j4)] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V.$[((Address.MatrixAddress)this.V.addr).op(k2, j4)] * f;
                    }
                    this.e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n = j4;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j4] * this.d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n = j3;
                    this.e[n] = this.e[n] - hh * this.d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = this.d[j3];
                    g = this.e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        int n = ((Address.MatrixAddress)this.V.addr).op(k3, j3);
                        this.V.$[n] = this.V.$[n] - (f * this.e[k3] + g * this.d[k3]);
                    }
                    this.d[j3] = this.V.$[((Address.MatrixAddress)this.V.addr).op(i - 1, j3)];
                    this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i, (int)j3)] = 0.0;
                }
            }
            this.d[i] = h;
        }
        for (i = 0; i < this.n - 1; ++i) {
            int k;
            this.V.$[((Address.MatrixAddress)this.V.addr).op((int)(this.n - 1), (int)i)] = this.V.$[((Address.MatrixAddress)this.V.addr).op(i, i)];
            this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i, (int)i)] = 1.0;
            double h = this.d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    this.d[k] = this.V.$[((Address.MatrixAddress)this.V.addr).op(k, i + 1)] / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += this.V.$[((Address.MatrixAddress)this.V.addr).op(k4, i + 1)] * this.V.$[((Address.MatrixAddress)this.V.addr).op(k4, j5)];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        int n = ((Address.MatrixAddress)this.V.addr).op(k4, j5);
                        this.V.$[n] = this.V.$[n] - g * this.d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this.V.$[((Address.MatrixAddress)this.V.addr).op((int)k, (int)(i + 1))] = 0.0;
            }
        }
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V.$[((Address.MatrixAddress)this.V.addr).op(this.n - 1, j)];
            this.V.$[((Address.MatrixAddress)this.V.addr).op((int)(this.n - 1), (int)j)] = 0.0;
        }
        this.V.$[((Address.MatrixAddress)this.V.addr).op((int)(this.n - 1), (int)(this.n - 1))] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i2];
                        h = c * p;
                        r = Math.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s * r;
                        s = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s * g;
                        this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                        for (int k = 0; k < this.n; ++k) {
                            h = this.V.$[((Address.MatrixAddress)this.V.addr).op(k, i2 + 1)];
                            this.V.$[((Address.MatrixAddress)this.V.addr).op((int)k, (int)(i2 + 1))] = s * this.V.$[((Address.MatrixAddress)this.V.addr).op(k, i2)] + c * h;
                            this.V.$[((Address.MatrixAddress)this.V.addr).op((int)k, (int)i2)] = c * this.V.$[((Address.MatrixAddress)this.V.addr).op(k, i2)] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int j;
            int k = i;
            double p = this.d[i];
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            for (j = 0; j < this.n; ++j) {
                p = this.V.$[((Address.MatrixAddress)this.V.addr).op(j, i)];
                this.V.$[((Address.MatrixAddress)this.V.addr).op((int)j, (int)i)] = this.V.$[((Address.MatrixAddress)this.V.addr).op(j, k)];
                this.V.$[((Address.MatrixAddress)this.V.addr).op((int)j, (int)k)] = p;
            }
        }
    }

    private void orthes() {
        int m;
        boolean low = false;
        int high = this.n - 1;
        for (m = 1; m <= high - 1; ++m) {
            double f;
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(i, m - 1)]);
            }
            if (scale == 0.0) continue;
            double h = 0.0;
            for (int i = high; i >= m; --i) {
                this.ort[i] = this.H.$[((Address.MatrixAddress)this.H.addr).op(i, m - 1)] / scale;
                h += this.ort[i] * this.ort[i];
            }
            double g = Math.sqrt(h);
            if (this.ort[m] > 0.0) {
                g = -g;
            }
            h -= this.ort[m] * g;
            this.ort[m] = this.ort[m] - g;
            for (int j = m; j < this.n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m; --i) {
                    f += this.ort[i] * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, j)];
                }
                f /= h;
                for (i = m; i <= high; ++i) {
                    int n = ((Address.MatrixAddress)this.H.addr).op(i, j);
                    this.H.$[n] = this.H.$[n] - f * this.ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += this.ort[j] * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, j)];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    int n = ((Address.MatrixAddress)this.H.addr).op(i, j);
                    this.H.$[n] = this.H.$[n] - f * this.ort[j];
                }
            }
            this.ort[m] = scale * this.ort[m];
            this.H.$[((Address.MatrixAddress)this.H.addr).op((int)m, (int)(m - 1))] = scale * g;
        }
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i, (int)j)] = i == j ? 1.0 : 0.0;
            }
        }
        for (m = high - 1; m >= 1; --m) {
            if (this.H.$[((Address.MatrixAddress)this.H.addr).op(m, m - 1)] == 0.0) continue;
            for (int i = m + 1; i <= high; ++i) {
                this.ort[i] = this.H.$[((Address.MatrixAddress)this.H.addr).op(i, m - 1)];
            }
            for (int j = m; j <= high; ++j) {
                int i;
                double g = 0.0;
                for (i = m; i <= high; ++i) {
                    g += this.ort[i] * this.V.$[((Address.MatrixAddress)this.V.addr).op(i, j)];
                }
                g = g / this.ort[m] / this.H.$[((Address.MatrixAddress)this.H.addr).op(m, m - 1)];
                for (i = m; i <= high; ++i) {
                    int n = ((Address.MatrixAddress)this.V.addr).op(i, j);
                    this.V.$[n] = this.V.$[n] + g * this.ort[i];
                }
            }
        }
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    private void hqr2() {
        double y;
        int i;
        int j;
        double x;
        double w;
        int l;
        int j2;
        int nn = this.n;
        int n = nn - 1;
        boolean low = false;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = 0.0;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < 0 | i2 > high) {
                this.d[i2] = this.H.$[((Address.MatrixAddress)this.H.addr).op(i2, i2)];
                this.e[i2] = 0.0;
            }
            for (j2 = Math.max(i2 - 1, 0); j2 < nn; ++j2) {
                norm += Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(i2, j2)]);
            }
        }
        int iter = 0;
        block2: while (n >= 0) {
            int m;
            for (l = n; l > 0; --l) {
                s = Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(l - 1, l - 1)]) + Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(l, l)]);
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(l, l - 1)]) < eps * s) break;
            }
            if (l == n) {
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)n, (int)n)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n)] + exshift;
                this.d[n] = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n)];
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n - 1)] * this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n)];
                p = (this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n - 1)] - this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n)]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)n, (int)n)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n)] + exshift;
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(n - 1), (int)(n - 1))] = this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n - 1)] + exshift;
                x = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n)];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0;
                    this.e[n] = 0.0;
                    x = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n - 1)];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, j)];
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(n - 1), (int)j)] = q * z + p * this.H.$[((Address.MatrixAddress)this.H.addr).op(n, j)];
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)n, (int)j)] = q * this.H.$[((Address.MatrixAddress)this.H.addr).op(n, j)] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n - 1)];
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)(n - 1))] = q * z + p * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n)];
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)n)] = q * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n)] - p * z;
                    }
                    for (i = 0; i <= high; ++i) {
                        z = this.V.$[((Address.MatrixAddress)this.V.addr).op(i, n - 1)];
                        this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i, (int)(n - 1))] = q * z + p * this.V.$[((Address.MatrixAddress)this.V.addr).op(i, n)];
                        this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i, (int)n)] = q * this.V.$[((Address.MatrixAddress)this.V.addr).op(i, n)] - p * z;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n)];
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n - 1)];
                w = this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n - 1)] * this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n)];
            }
            if (iter == 10) {
                exshift += x;
                for (i = 0; i <= n; ++i) {
                    int n2 = ((Address.MatrixAddress)this.H.addr).op(i, i);
                    this.H.$[n2] = this.H.$[n2] - x;
                }
                s = Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n - 1)]) + Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n - 2)]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    for (i = 0; i <= n; ++i) {
                        int n3 = ((Address.MatrixAddress)this.H.addr).op(i, i);
                        this.H.$[n3] = this.H.$[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = this.H.$[((Address.MatrixAddress)this.H.addr).op(m, m)];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.H.$[((Address.MatrixAddress)this.H.addr).op(m + 1, m)] + this.H.$[((Address.MatrixAddress)this.H.addr).op(m, m + 1)];
                q = this.H.$[((Address.MatrixAddress)this.H.addr).op(m + 1, m + 1)] - z - r - s;
                r = this.H.$[((Address.MatrixAddress)this.H.addr).op(m + 2, m + 1)];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(m, m - 1)]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(m - 1, m - 1)]) + Math.abs(z) + Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(m + 1, m + 1)])))) break;
            }
            for (int i3 = m + 2; i3 <= n; ++i3) {
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i3, (int)(i3 - 2))] = 0.0;
                if (i3 <= m + 2) continue;
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i3, (int)(i3 - 3))] = 0.0;
            }
            for (int k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.H.$[((Address.MatrixAddress)this.H.addr).op(k, k - 1)];
                    q = this.H.$[((Address.MatrixAddress)this.H.addr).op(k + 1, k - 1)];
                    r = notlast ? this.H.$[((Address.MatrixAddress)this.H.addr).op(k + 2, k - 1)] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block2;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)k, (int)(k - 1))] = -s * x;
                } else if (l != m) {
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)k, (int)(k - 1))] = -this.H.$[((Address.MatrixAddress)this.H.addr).op(k, k - 1)];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < nn; ++j3) {
                    p = this.H.$[((Address.MatrixAddress)this.H.addr).op(k, j3)] + q * this.H.$[((Address.MatrixAddress)this.H.addr).op(k + 1, j3)];
                    if (notlast) {
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(k + 2), (int)j3)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(k + 2, j3)] - (p += r * this.H.$[((Address.MatrixAddress)this.H.addr).op(k + 2, j3)]) * z;
                    }
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)k, (int)j3)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(k, j3)] - p * x;
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(k + 1), (int)j3)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(k + 1, j3)] - p * y;
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * this.H.$[((Address.MatrixAddress)this.H.addr).op(i4, k)] + y * this.H.$[((Address.MatrixAddress)this.H.addr).op(i4, k + 1)];
                    if (notlast) {
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i4, (int)(k + 2))] = this.H.$[((Address.MatrixAddress)this.H.addr).op(i4, k + 2)] - (p += z * this.H.$[((Address.MatrixAddress)this.H.addr).op(i4, k + 2)]) * r;
                    }
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i4, (int)k)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(i4, k)] - p;
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i4, (int)(k + 1))] = this.H.$[((Address.MatrixAddress)this.H.addr).op(i4, k + 1)] - p * q;
                }
                for (i4 = 0; i4 <= high; ++i4) {
                    p = x * this.V.$[((Address.MatrixAddress)this.V.addr).op(i4, k)] + y * this.V.$[((Address.MatrixAddress)this.V.addr).op(i4, k + 1)];
                    if (notlast) {
                        this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i4, (int)(k + 2))] = this.V.$[((Address.MatrixAddress)this.V.addr).op(i4, k + 2)] - (p += z * this.V.$[((Address.MatrixAddress)this.V.addr).op(i4, k + 2)]) * r;
                    }
                    this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i4, (int)k)] = this.V.$[((Address.MatrixAddress)this.V.addr).op(i4, k)] - p;
                    this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i4, (int)(k + 1))] = this.V.$[((Address.MatrixAddress)this.V.addr).op(i4, k + 1)] - p * q;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)n, (int)n)] = 1.0;
                for (i = n - 1; i >= 0; --i) {
                    int j4;
                    w = this.H.$[((Address.MatrixAddress)this.H.addr).op(i, i)] - p;
                    r = 0.0;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += this.H.$[((Address.MatrixAddress)this.H.addr).op(i, j4)] * this.H.$[((Address.MatrixAddress)this.H.addr).op(j4, n)];
                    }
                    if (this.e[i] < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (this.e[i] == 0.0) {
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)n)] = w != 0.0 ? -r / w : -r / (eps * norm);
                    } else {
                        x = this.H.$[((Address.MatrixAddress)this.H.addr).op(i, i + 1)];
                        y = this.H.$[((Address.MatrixAddress)this.H.addr).op(i + 1, i)];
                        q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)n)] = t = (x * s - z * r) / q;
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(i + 1), (int)n)] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n)]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i; j4 <= n; ++j4) {
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)j4, (int)n)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(j4, n)] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n - 1)]) > Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n)])) {
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(n - 1), (int)(n - 1))] = q / this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n - 1)];
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(n - 1), (int)n)] = -(this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n)] - p) / this.H.$[((Address.MatrixAddress)this.H.addr).op(n, n - 1)];
            } else {
                this.cdiv(0.0, -this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n)], this.H.$[((Address.MatrixAddress)this.H.addr).op(n - 1, n - 1)] - p, q);
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(n - 1), (int)(n - 1))] = this.cdivr;
                this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(n - 1), (int)n)] = this.cdivi;
            }
            this.H.$[((Address.MatrixAddress)this.H.addr).op((int)n, (int)(n - 1))] = 0.0;
            this.H.$[((Address.MatrixAddress)this.H.addr).op((int)n, (int)n)] = 1.0;
            for (i = n - 2; i >= 0; --i) {
                int j5;
                double ra = 0.0;
                double sa = 0.0;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += this.H.$[((Address.MatrixAddress)this.H.addr).op(i, j5)] * this.H.$[((Address.MatrixAddress)this.H.addr).op(j5, n - 1)];
                    sa += this.H.$[((Address.MatrixAddress)this.H.addr).op(i, j5)] * this.H.$[((Address.MatrixAddress)this.H.addr).op(j5, n)];
                }
                w = this.H.$[((Address.MatrixAddress)this.H.addr).op(i, i)] - p;
                if (this.e[i] < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (this.e[i] == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)(n - 1))] = this.cdivr;
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)n)] = this.cdivi;
                } else {
                    double vi;
                    x = this.H.$[((Address.MatrixAddress)this.H.addr).op(i, i + 1)];
                    y = this.H.$[((Address.MatrixAddress)this.H.addr).op(i + 1, i)];
                    double vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                    if (vr == 0.0 & (vi = (this.d[i] - p) * 2.0 * q) == 0.0) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)(n - 1))] = this.cdivr;
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)i, (int)n)] = this.cdivi;
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(i + 1), (int)(n - 1))] = (-ra - w * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n - 1)] + q * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n)]) / x;
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(i + 1), (int)n)] = (-sa - w * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n)] - q * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n - 1)]) / x;
                    } else {
                        this.cdiv(-r - y * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n - 1)], -s - y * this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n)], z, q);
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(i + 1), (int)(n - 1))] = this.cdivr;
                        this.H.$[((Address.MatrixAddress)this.H.addr).op((int)(i + 1), (int)n)] = this.cdivi;
                    }
                }
                t = Math.max(Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n - 1)]), Math.abs(this.H.$[((Address.MatrixAddress)this.H.addr).op(i, n)]));
                if (!(eps * t * t > 1.0)) continue;
                for (j5 = i; j5 <= n; ++j5) {
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)j5, (int)(n - 1))] = this.H.$[((Address.MatrixAddress)this.H.addr).op(j5, n - 1)] / t;
                    this.H.$[((Address.MatrixAddress)this.H.addr).op((int)j5, (int)n)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(j5, n)] / t;
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (!(i5 < 0 | i5 > high)) continue;
            for (j = i5; j < nn; ++j) {
                this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i5, (int)j)] = this.H.$[((Address.MatrixAddress)this.H.addr).op(i5, j)];
            }
        }
        for (j2 = nn - 1; j2 >= 0; --j2) {
            for (i = 0; i <= high; ++i) {
                z = 0.0;
                for (int k = 0; k <= Math.min(j2, high); ++k) {
                    z += this.V.$[((Address.MatrixAddress)this.V.addr).op(i, k)] * this.H.$[((Address.MatrixAddress)this.H.addr).op(k, j2)];
                }
                this.V.$[((Address.MatrixAddress)this.V.addr).op((int)i, (int)j2)] = z;
            }
        }
    }
}

