/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.Ops;
import org.jquantlib.math.functions.LessThanPredicate;
import org.jquantlib.math.matrixutilities.Algebra;
import org.jquantlib.math.matrixutilities.Cells;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.math.matrixutilities.internal.DirectArrayRowAddress;

@QualityAssurance(quality=QualityAssurance.Quality.Q2_RESEMBLANCE, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Array
extends Cells<Address.ArrayAddress>
implements Cloneable,
Iterable<Double>,
Algebra<Array> {
    public Array() {
        this(0, EnumSet.noneOf(Address.Flags.class));
    }

    public Array(Set<Address.Flags> flags) {
        super(1, 1, null);
        this.addr = new DirectArrayRowAddress(this.$, 0, null, 0, 0, flags, true, 1, 1);
    }

    public Array(int size) {
        this(size, EnumSet.noneOf(Address.Flags.class));
    }

    public Array(int size, Set<Address.Flags> flags) {
        super(1, size, null);
        this.addr = new DirectArrayRowAddress(this.$, 0, null, 0, size - 1, flags, true, 1, size);
    }

    public Array(double[] array) {
        this(array, EnumSet.noneOf(Address.Flags.class));
    }

    public Array(double[] array, Set<Address.Flags> flags) {
        super(1, array.length, null);
        this.addr = new DirectArrayRowAddress(this.$, 0, null, 0, array.length - 1, flags, true, 1, array.length);
        System.arraycopy(array, 0, this.$, 0, this.size());
    }

    public Array(double[] array, int size) {
        this(array, size, EnumSet.noneOf(Address.Flags.class));
    }

    public Array(double[] array, int size, Set<Address.Flags> flags) {
        super(1, size, null);
        this.addr = new DirectArrayRowAddress(this.$, 0, null, 0, size - 1, flags, true, 1, size);
        System.arraycopy(array, 0, this.$, 0, this.size());
    }

    public Array(Array array) {
        this(array, EnumSet.noneOf(Address.Flags.class));
    }

    public Array(Array array, Set<Address.Flags> flags) {
        super(1, array.size(), null);
        this.addr = new DirectArrayRowAddress(this.$, 0, null, 0, array.size(), array.flags(), true, 1, array.size());
        if (((Address.ArrayAddress)array.addr).isContiguous()) {
            int begin = ((Address.ArrayAddress)array.addr).col0() + (((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0);
            System.arraycopy(array.$, begin, this.$, 0, this.size());
        } else {
            for (int i = 0; i < array.size(); ++i) {
                this.$[i] = array.get(i);
            }
        }
    }

    protected Array(int rows, int cols, double[] data, Address.ArrayAddress addr) {
        super(rows, cols, data, addr);
    }

    @Override
    public Array clone() {
        Array clone = (Array)super.clone();
        clone.$ = new double[this.size()];
        clone.addr = new DirectArrayRowAddress(clone.$, 0, null, 0, this.size(), this.flags(), true, 1, this.size());
        if (((Address.ArrayAddress)this.addr).isContiguous()) {
            int begin = ((Address.ArrayAddress)this.addr).col0() + (((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0);
            System.arraycopy(this.$, begin, clone.$, 0, this.size());
        } else {
            for (int i = 0; i < this.size(); ++i) {
                clone.$[i] = this.get(i);
            }
        }
        return clone;
    }

    @Deprecated
    public int _(int index) {
        return ((Address.ArrayAddress)this.addr).op(index);
    }

    public int begin() {
        return ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
    }

    public int end() {
        return this.size() + (((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0);
    }

    public double first() {
        return this.$[this._(((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0)];
    }

    public double last() {
        return this.$[this._(this.end() - 1)];
    }

    public double get(int pos) {
        return this.$[((Address.ArrayAddress)this.addr).op(pos)];
    }

    public void set(int pos, double value) {
        this.$[((Address.ArrayAddress)this.addr).op((int)pos)] = value;
    }

    @Override
    public Array addAssign(double scalar) {
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = src.op();
            this.$[n] = this.$[n] + scalar;
            src.nextIndex();
        }
        return this;
    }

    @Override
    public Array subAssign(double scalar) {
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = src.op();
            this.$[n] = this.$[n] - scalar;
            src.nextIndex();
        }
        return this;
    }

    @Override
    public Array subAssign(Array another) {
        QL.require(this.size() == another.size(), "array is incompatible");
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = toff.op();
            this.$[n] = this.$[n] - another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return this;
    }

    @Override
    public Array mulAssign(double scalar) {
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = src.op();
            this.$[n] = this.$[n] * scalar;
            src.nextIndex();
        }
        return this;
    }

    @Override
    public Array divAssign(double scalar) {
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = src.op();
            this.$[n] = this.$[n] / scalar;
            src.nextIndex();
        }
        return this;
    }

    @Override
    public Array addAssign(Array another) {
        QL.require(this.size() == another.size(), "array is incompatible");
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = toff.op();
            this.$[n] = this.$[n] + another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return this;
    }

    @Override
    public Array mulAssign(Array another) {
        QL.require(this.size() == another.size(), "array is incompatible");
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = toff.op();
            this.$[n] = this.$[n] * another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return this;
    }

    @Override
    public Array divAssign(Array another) {
        QL.require(this.size() == another.size(), "array is incompatible");
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            int n = toff.op();
            this.$[n] = this.$[n] / another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return this;
    }

    @Override
    public Array add(double scalar) {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[src.op()] + scalar;
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array sub(double scalar) {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[src.op()] - scalar;
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array mul(double scalar) {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[src.op()] * scalar;
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array negative() {
        return this.mul(-1.0);
    }

    @Override
    public Array div(double scalar) {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[src.op()] / scalar;
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array add(Array another) {
        QL.require(this.size() == another.size(), "matrix is incompatible");
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[toff.op()] + another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return result;
    }

    @Override
    public Array sub(Array another) {
        QL.require(this.size() == another.size(), "matrix is incompatible");
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[toff.op()] - another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return result;
    }

    @Override
    public Array mul(Array another) {
        QL.require(this.size() == another.size(), "matrix is incompatible");
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[toff.op()] * another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return result;
    }

    @Override
    public Array div(Array another) {
        QL.require(this.size() == another.size(), "matrix is incompatible");
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset();
        for (int col = 0; col < this.size(); ++col) {
            result.$[col] = this.$[toff.op()] / another.$[aoff.op()];
            toff.nextIndex();
            aoff.nextIndex();
        }
        return result;
    }

    @Override
    public Array mul(Matrix matrix) {
        QL.require(this.size() == matrix.rows(), "matrix is incompatible");
        Array result = new Array(matrix.cols());
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.MatrixAddress.MatrixOffset moff = ((Address.MatrixAddress)matrix.addr).offset();
        int offsetA = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        int offsetM = ((Address.MatrixAddress)matrix.addr).isFortran() ? 1 : 0;
        for (int col = 0; col < matrix.cols(); ++col) {
            toff.setIndex(offsetA);
            moff.setRow(offsetM);
            moff.setCol(col + offsetM);
            double sum = 0.0;
            for (int row = 0; row < matrix.rows(); ++row) {
                double telem = this.$[toff.op()];
                double aelem = matrix.$[moff.op()];
                sum += telem * aelem;
                toff.nextIndex();
                moff.nextRow();
            }
            result.$[col] = sum;
        }
        return result;
    }

    @Override
    public double min() {
        return this.min(0, this.size());
    }

    @Override
    public double min(int from, int to) {
        QL.require(from >= 0 && to > from && to <= this.size(), "invalid arguments");
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset(from + offset);
        double result = this.$[src.op()];
        for (int i = 0; i < to - from; ++i) {
            double tmp = this.$[src.op()];
            src.nextIndex();
            if (!(tmp < result)) continue;
            result = tmp;
        }
        return result;
    }

    @Override
    public double max() {
        return this.max(0, this.size());
    }

    @Override
    public double max(int from, int to) {
        QL.require(from >= 0 && to > from && to <= this.size(), "invalid arguments");
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset(from + offset);
        double result = this.$[src.op()];
        for (int i = 0; i < to - from; ++i) {
            double tmp = this.$[src.op()];
            src.nextIndex();
            if (!(tmp > result)) continue;
            result = tmp;
        }
        return result;
    }

    @Override
    public Array abs() {
        int offset;
        Array result = new Array(this.size(), ((Address.ArrayAddress)this.addr).flags());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0; i < this.size() + offset; ++i) {
            result.$[result._((int)i)] = Math.abs(this.$[src.op()]);
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array sqr() {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            double a = this.$[src.op()];
            result.$[i] = a * a;
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array sqrt() {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            result.$[i] = Math.sqrt(this.$[src.op()]);
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array log() {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            result.$[i] = Math.log(this.$[src.op()]);
            src.nextIndex();
        }
        return result;
    }

    @Override
    public Array exp() {
        Array result = new Array(this.size());
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset();
        for (int i = 0; i < this.size(); ++i) {
            result.$[i] = Math.exp(this.$[src.op()]);
            src.nextIndex();
        }
        return result;
    }

    @Override
    public double dotProduct(Array another) {
        int offset = ((Address.ArrayAddress)another.addr).isFortran() ? 1 : 0;
        return this.dotProduct(another, offset, another.size() + offset);
    }

    @Override
    public double dotProduct(Array another, int from, int to) {
        int offset = ((Address.ArrayAddress)another.addr).isFortran() ? 1 : 0;
        QL.require(from >= offset && to >= from && to <= another.size() + offset, "invalid arguments");
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset(from);
        double sum = 0.0;
        for (int i = 0; i < to - from; ++i) {
            double telem = this.$[toff.op()];
            double aelem = another.$[aoff.op()];
            sum += telem * aelem;
            toff.nextIndex();
            aoff.nextIndex();
        }
        return sum;
    }

    @Override
    public double innerProduct(Array another) {
        return this.dotProduct(another);
    }

    @Override
    public double innerProduct(Array another, int from, int to) {
        return this.dotProduct(another, from, to);
    }

    @Override
    public Matrix outerProduct(Array another) {
        int offset = ((Address.ArrayAddress)another.addr).isFortran() ? 1 : 0;
        return this.outerProduct(another, offset, another.size() + offset);
    }

    @Override
    public Matrix outerProduct(Array another, int from, int to) {
        int offset = ((Address.ArrayAddress)another.addr).isFortran() ? 1 : 0;
        QL.require(from >= offset && to >= from && to <= another.size() + offset, "invalid arguments");
        Matrix result = new Matrix(this.size(), to - from);
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset();
        int addr = 0;
        for (int i = 0; i < this.size(); ++i) {
            Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)another.addr).offset(from);
            for (int j = from; j < to; ++j) {
                result.$[addr] = this.$[toff.op()] * another.$[aoff.op()];
                ++addr;
                aoff.nextIndex();
            }
            toff.nextIndex();
        }
        return result;
    }

    @Override
    public double accumulate() {
        return this.accumulate(0, this.size(), 0.0);
    }

    @Override
    public double accumulate(double init) {
        return this.accumulate(0, this.size(), init);
    }

    @Override
    public double accumulate(int first, int last, double init) {
        QL.require(first >= 0 && last > first && last <= this.size(), "invalid arguments");
        double sum = init;
        Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)this.addr).offset(first);
        for (int i = 0; i < last - first; ++i) {
            double elem = this.$[src.op()];
            sum += elem;
            src.nextIndex();
        }
        return sum;
    }

    @Override
    public final Array adjacentDifference() {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        return this.adjacentDifference(offset, this.size() + offset);
    }

    @Override
    public final Array adjacentDifference(int from, int to) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(from >= offset && to >= from && to <= this.size() + offset, "invalid arguments");
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset(from);
        Array diff = new Array(to - from, this.flags());
        double prev = this.$[toff.op()];
        toff.nextIndex();
        diff.$[diff._((int)offset)] = prev;
        for (int i = 1 + offset; i < to - from + offset; ++i) {
            double curr = this.$[toff.op()];
            toff.nextIndex();
            diff.$[diff._((int)i)] = curr - prev;
            prev = curr;
        }
        return diff;
    }

    @Override
    public Array adjacentDifference(Ops.BinaryDoubleOp f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        return this.adjacentDifference(offset, this.size() + offset, f);
    }

    @Override
    public Array adjacentDifference(int from, int to, Ops.BinaryDoubleOp f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(from >= offset && to >= from && to <= this.size() + offset, "invalid arguments");
        Address.ArrayAddress.ArrayOffset toff = ((Address.ArrayAddress)this.addr).offset(from);
        Array diff = new Array(to - from, this.flags());
        double prev = this.$[toff.op()];
        toff.nextIndex();
        diff.$[diff._((int)offset)] = prev;
        for (int i = 1 + offset; i < to - from + offset; ++i) {
            double curr = this.$[toff.op()];
            toff.nextIndex();
            diff.$[diff._((int)i)] = f.op(curr, prev);
            prev = curr;
        }
        return diff;
    }

    @Override
    public Array transform(Ops.DoubleOp f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        return this.transform(offset, this.size() + offset, f);
    }

    @Override
    public Array transform(int from, int to, Ops.DoubleOp f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(from >= offset && to >= from && to <= this.size() + offset && f != null, "invalid arguments");
        for (int i = from; i < to; ++i) {
            int idx = this._(i);
            this.$[idx] = f.op(this.$[idx]);
        }
        return this;
    }

    @Override
    public int lowerBound(double val) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        return this.lowerBound(offset, this.size() + offset, val, new LessThanPredicate());
    }

    @Override
    public int lowerBound(int from, int to, double val) {
        return this.lowerBound(from, to, val, new LessThanPredicate());
    }

    @Override
    public int lowerBound(double val, Ops.BinaryDoublePredicate f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        return this.lowerBound(offset, this.size() + offset, val, f);
    }

    @Override
    public int lowerBound(int from, int to, double val, Ops.BinaryDoublePredicate f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(from >= offset && from <= to && to <= this.size() + offset, "invalid arguments");
        int len = to - from;
        while (len > 0) {
            int half = len >> 1;
            int middle = from - offset + half;
            if (f.op(this.$[((Address.ArrayAddress)this.addr).op(middle + offset)], val)) {
                from = middle + offset + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    @Override
    public int upperBound(double val) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        return this.upperBound(offset, this.size() + offset, val);
    }

    @Override
    public int upperBound(int from, int to, double val) {
        return this.upperBound(from, to, val, new LessThanPredicate());
    }

    @Override
    public int upperBound(double val, Ops.BinaryDoublePredicate f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        return this.upperBound(offset, this.size() + offset, val, f);
    }

    @Override
    public int upperBound(int from, int to, double val, Ops.BinaryDoublePredicate f) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(from >= offset && from <= to && to <= this.size() + offset, "invalid arguments");
        int len = to - from;
        while (len > 0) {
            int half = len >> 1;
            int middle = from - offset + half;
            if (f.op(val, this.$[((Address.ArrayAddress)this.addr).op(middle + offset)])) {
                len = half;
                continue;
            }
            from = middle + offset + 1;
            len -= half + 1;
        }
        return from;
    }

    public Array range(int col0) {
        return this.range(col0, this.cols());
    }

    public Array range(int col0, int col1) {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(col0 >= offset && col0 < this.cols() + offset && col1 >= offset && col1 <= this.cols() + offset, "invalid column index");
        return new Range(offset, (Address.ArrayAddress)this.addr, this.$, col0, col1, this.rows(), this.cols());
    }

    public Array toFortran() {
        return ((Address.ArrayAddress)this.addr).isFortran() ? this : new Array(this.rows, this.cols, this.$, ((Address.ArrayAddress)this.addr).toFortran());
    }

    public Array toJava() {
        return ((Address.ArrayAddress)this.addr).isFortran() ? new Array(this.rows, this.cols, this.$, ((Address.ArrayAddress)this.addr).toJava()) : this;
    }

    public Array fill(double scalar) {
        QL.require(((Address.ArrayAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        Arrays.fill(this.$, this.begin() - offset, this.end() - offset, scalar);
        return this;
    }

    public Array fill(Array another) {
        QL.require(((Address.ArrayAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(((Address.ArrayAddress)another.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(this.rows() == another.rows() && this.cols() == another.cols() && this.size() == another.size(), "wrong buffer length");
        int offsetT = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        int offsetA = ((Address.ArrayAddress)another.addr).isFortran() ? 1 : 0;
        System.arraycopy(another.$, another.begin() - offsetA, this.$, this.begin() - offsetT, another.size());
        return this;
    }

    public Array swap(Array another) {
        QL.require(((Address.ArrayAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(((Address.ArrayAddress)another.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(this.rows() == another.rows() && this.cols() == another.cols() && this.size() == another.size(), "wrong buffer length");
        double[] tdata = this.$;
        this.$ = another.$;
        another.$ = tdata;
        Address.ArrayAddress taddr = (Address.ArrayAddress)this.addr;
        this.addr = another.addr;
        another.addr = taddr;
        return this;
    }

    public Array sort() {
        QL.require(((Address.ArrayAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        Arrays.sort(this.$, this.begin() - offset, this.end() - offset);
        return this;
    }

    public String toString() {
        int offset = ((Address.ArrayAddress)this.addr).isFortran() ? 1 : 0;
        StringBuffer sb = new StringBuffer();
        sb.append("[rows=").append(this.rows()).append(" cols=").append(this.cols()).append(" addr=").append(this.addr).append('\n');
        sb.append("  [ ");
        sb.append(this.$[((Address.ArrayAddress)this.addr).op(offset)]);
        for (int pos = 1 + offset; pos < this.size() + offset; ++pos) {
            sb.append(", ");
            sb.append(this.$[((Address.ArrayAddress)this.addr).op(pos)]);
        }
        sb.append("  ]\n");
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public Iterator<Double> iterator() {
        return ((Address.ArrayAddress)this.addr).offset();
    }

    private class Range
    extends Array {
        public Range(int row0, Address.ArrayAddress chain, double[] data, int col0, int col1, int rows, int cols) {
            super(1, col1 - col0, data, new DirectArrayRowAddress(data, row0, chain, col0, col1, null, true, rows, cols));
        }
    }
}

