/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.matrixutilities.Array;

public class BackwardFlatInterpolation
extends AbstractInterpolation {
    public BackwardFlatInterpolation(Array vx, Array vy) {
        this.impl = new BackwardFlatInterpolationImpl(vx, vy);
        this.impl.update();
    }

    private class BackwardFlatInterpolationImpl
    extends AbstractInterpolation.Impl {
        private final Array vp;

        protected BackwardFlatInterpolationImpl(Array vx, Array vy) {
            super(vx, vy);
            this.vp = new Array(vx.size());
        }

        @Override
        public void update() {
            this.vp.set(0, 0.0);
            for (int i = 1; i < this.vx.size(); ++i) {
                double dx = this.vx.get(i) - this.vx.get(i - 1);
                this.vp.set(i, this.vp.get(i - 1) + dx * this.vy.get(i));
            }
        }

        @Override
        public double op(double x) {
            if (x <= this.vx.get(0)) {
                return this.vy.get(0);
            }
            int i = this.locate(x);
            if (x == this.vx.get(i)) {
                return this.vy.get(i);
            }
            return this.vy.get(i + 1);
        }

        @Override
        public double primitive(double x) {
            int i = this.locate(x);
            double dx = x - this.vx.get(i);
            return this.vp.get(i) + dx * this.vy.get(i + 1);
        }

        @Override
        public double derivative(double x) {
            return 0.0;
        }

        @Override
        public double secondDerivative(double x) {
            return 0.0;
        }
    }
}

