/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.TrapezoidIntegral;

public class SimpsonIntegral
extends TrapezoidIntegral<TrapezoidIntegral.Default> {
    public SimpsonIntegral(double accuracy, int maxIterations) {
        super(TrapezoidIntegral.Default.class, accuracy, maxIterations);
    }

    @Override
    protected double integrate(Ops.DoubleOp f, double a, double b) {
        double I;
        int N = 1;
        double adjI = I = (f.op(a) + f.op(b)) * (b - a) / 2.0;
        int i = 1;
        do {
            double newI = this.policy.integrate(f, a, b, I, N);
            N *= 2;
            double newAdjI = (4.0 * newI - I) / 3.0;
            if (Math.abs(adjI - newAdjI) <= this.absoluteAccuracy() && i > 5) {
                return newAdjI;
            }
            I = newI;
            adjI = newAdjI;
        } while (++i < this.maxEvaluations());
        throw new ArithmeticException("max number of iterations reached");
    }
}

