/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;

public abstract class Integrator {
    private double absoluteAccuracy;
    private int maxEvaluations;
    private double absoluteError;
    private int numberOfEvaluations;

    public Integrator(double absoluteAccuracy, int maxEvaluations) {
        QL.require(absoluteAccuracy > Constants.QL_EPSILON, "required tolerance must be > epsilon");
        this.absoluteAccuracy = absoluteAccuracy;
        this.maxEvaluations = maxEvaluations;
    }

    public final double op(Ops.DoubleOp f, double a, double b) {
        if (a == b) {
            return 0.0;
        }
        if (b > a) {
            return this.integrate(f, a, b);
        }
        return -this.integrate(f, b, a);
    }

    public boolean isIntegrationSuccess() {
        return this.numberOfEvaluations <= this.maxEvaluations && this.absoluteError <= this.absoluteAccuracy;
    }

    public final double absoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    public final void setAbsoluteAccuracy(double accuracy) {
        this.absoluteAccuracy = accuracy;
    }

    public final int maxEvaluations() {
        return this.maxEvaluations;
    }

    public final void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public final double absoluteError() {
        return this.absoluteError;
    }

    protected final void setAbsoluteError(double error) {
        this.absoluteError = error;
    }

    protected final void setNumberOfEvaluations(int evaluations) {
        this.numberOfEvaluations = evaluations;
    }

    protected final void increaseNumberOfEvaluations(int increase) {
        this.numberOfEvaluations += increase;
    }

    protected int numberOfEvaluations() {
        return this.numberOfEvaluations;
    }

    protected abstract double integrate(Ops.DoubleOp var1, double var2, double var4);
}

