/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.KronrodIntegral;

public class GaussKronrodNonAdaptive
extends KronrodIntegral {
    private double relativeAccuracy_;

    public double relativeAccuracy() {
        return this.relativeAccuracy_;
    }

    public void setRelativeAccuracy(double relativeAccuracy) {
        this.relativeAccuracy_ = relativeAccuracy;
    }

    public GaussKronrodNonAdaptive(double absoluteAccuracy, int maxEvaluations, double relativeAccuracy) {
        super(absoluteAccuracy, maxEvaluations);
        this.relativeAccuracy_ = relativeAccuracy;
    }

    @Override
    public double integrate(Ops.DoubleOp f, double a, double b) {
        double abscissa;
        double fval;
        double fval2;
        double fval1;
        double abscissa2;
        int k;
        double[] fv1 = new double[5];
        double[] fv2 = new double[5];
        double[] fv3 = new double[5];
        double[] fv4 = new double[5];
        double[] savfun = new double[21];
        QL.require(a < b, "b must be greater than a");
        double halfLength = 0.5 * (b - a);
        double center = 0.5 * (b + a);
        double fCenter = f.op(center);
        double res10 = 0.0;
        double res21 = this.w21b[5] * fCenter;
        double resAbs = this.w21b[5] * Math.abs(fCenter);
        for (k = 0; k < 5; ++k) {
            abscissa2 = halfLength * this.x1[k];
            fval1 = f.op(center + abscissa2);
            fval2 = f.op(center - abscissa2);
            fval = fval1 + fval2;
            res10 += this.w10[k] * fval;
            res21 += this.w21a[k] * fval;
            resAbs += this.w21a[k] * (Math.abs(fval1) + Math.abs(fval2));
            savfun[k] = fval;
            fv1[k] = fval1;
            fv2[k] = fval2;
        }
        for (k = 0; k < 5; ++k) {
            abscissa2 = halfLength * this.x2[k];
            fval1 = f.op(center + abscissa2);
            fval2 = f.op(center - abscissa2);
            fval = fval1 + fval2;
            res21 += this.w21b[k] * fval;
            resAbs += this.w21b[k] * (Math.abs(fval1) + Math.abs(fval2));
            savfun[k + 5] = fval;
            fv3[k] = fval1;
            fv4[k] = fval2;
        }
        double result = res21 * halfLength;
        resAbs *= halfLength;
        double mean = 0.5 * res21;
        double resasc = this.w21b[5] * Math.abs(fCenter - mean);
        for (k = 0; k < 5; ++k) {
            resasc += this.w21a[k] * (Math.abs(fv1[k] - mean) + Math.abs(fv2[k] - mean)) + this.w21b[k] * (Math.abs(fv3[k] - mean) + Math.abs(fv4[k] - mean));
        }
        double err = GaussKronrodNonAdaptive.rescaleError((res21 - res10) * halfLength, resAbs, resasc);
        resasc *= halfLength;
        if (err < this.absoluteAccuracy() || err < this.relativeAccuracy() * Math.abs(result)) {
            this.setAbsoluteError(err);
            this.setNumberOfEvaluations(21);
            return result;
        }
        double res43 = this.w43b[11] * fCenter;
        for (k = 0; k < 10; ++k) {
            res43 += savfun[k] * this.w43a[k];
        }
        for (k = 0; k < 11; ++k) {
            abscissa = halfLength * this.x3[k];
            double fval3 = f.op(center + abscissa) + f.op(center - abscissa);
            res43 += fval3 * this.w43b[k];
            savfun[k + 10] = fval3;
        }
        result = res43 * halfLength;
        err = GaussKronrodNonAdaptive.rescaleError((res43 - res21) * halfLength, resAbs, resasc);
        if (err < this.absoluteAccuracy() || err < this.relativeAccuracy() * Math.abs(result)) {
            this.setAbsoluteError(err);
            this.setNumberOfEvaluations(43);
            return result;
        }
        double res87 = this.w87b[22] * fCenter;
        for (k = 0; k < 21; ++k) {
            res87 += savfun[k] * this.w87a[k];
        }
        for (k = 0; k < 22; ++k) {
            abscissa = halfLength * this.x4[k];
            res87 += this.w87b[k] * (f.op(center + abscissa) + f.op(center - abscissa));
        }
        result = res87 * halfLength;
        err = GaussKronrodNonAdaptive.rescaleError((res87 - res43) * halfLength, resAbs, resasc);
        this.setAbsoluteError(err);
        this.setNumberOfEvaluations(87);
        return result;
    }

    static double rescaleError(double err, double resultAbs, double resultAsc) {
        double min_err;
        err = Math.abs(err);
        if (resultAsc != 0.0 && err != 0.0) {
            double scale = Math.pow(200.0 * err / resultAsc, 1.5);
            err = scale < 1.0 ? resultAsc * scale : resultAsc;
        }
        if (resultAbs > Double.MIN_VALUE / (50.0 * Constants.QL_EPSILON) && (min_err = 50.0 * Constants.QL_EPSILON * resultAbs) > err) {
            err = min_err;
        }
        return err;
    }
}

