/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.Factorial;
import org.jquantlib.math.Ops;

public class PoissonDistribution
implements Ops.IntToDouble {
    private final double mu;

    public PoissonDistribution(double mu) {
        QL.require(mu >= 0.0, "mu must be non negative");
        this.mu = mu;
    }

    @Override
    public double op(int k) {
        if (this.mu == 0.0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        Factorial fact = new Factorial();
        double logFactorial = fact.ln(k);
        return Math.exp((double)k * Math.log(this.mu) - logFactorial - this.mu);
    }
}

