/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.Factorial;
import org.jquantlib.math.Ops;

public class InverseCumulativePoisson
implements Ops.DoubleOp {
    private final double lambda;

    public InverseCumulativePoisson() {
        this(1.0);
    }

    public InverseCumulativePoisson(double lambda) {
        QL.require(lambda > 0.0, "lambda must be positive");
        this.lambda = lambda;
    }

    private double calcSummand(int index) {
        Factorial fact = new Factorial();
        return Math.exp(-this.lambda) * Math.pow(this.lambda, index) / fact.get(index);
    }

    @Override
    public double op(double x) {
        QL.require(x >= 0.0 && x <= 1.0, "undefined outside interval [0,1]");
        if (x == 1.0) {
            return Double.MAX_VALUE;
        }
        double sum = 0.0;
        int index = 0;
        while (x > sum) {
            sum += this.calcSummand(index);
            ++index;
        }
        return index - 1;
    }
}

