/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;
import org.jquantlib.math.distributions.GammaFunction;

public class GammaDistribution
implements Ops.DoubleOp {
    private static final String ACCURACY_NOT_REACHED = "accuracy not reached";
    private final double a;

    public GammaDistribution(double a) {
        QL.require(a >= 0.0, "invalid parameter for gamma distribution");
        this.a = a;
    }

    @Override
    public double op(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double gln = new GammaFunction().logValue(this.a);
        if (x < this.a + 1.0) {
            double del;
            double ap = this.a;
            double sum = del = 1.0 / this.a;
            for (int n = 1; n <= 100; ++n) {
                sum += (del *= x / (ap += 1.0));
                if (!(Math.abs(del) < Math.abs(sum) * 3.0E-7)) continue;
                return sum * Math.exp(-x + this.a * Math.log(x) - gln);
            }
        } else {
            double d;
            double b = x + 1.0 - this.a;
            double c = Double.MAX_VALUE;
            double h = d = 1.0 / b;
            for (int n = 1; n <= 100; ++n) {
                double an = -1.0 * (double)n * ((double)n - this.a);
                if (Math.abs(d = an * d + (b += 2.0)) < Constants.QL_EPSILON) {
                    d = Constants.QL_EPSILON;
                }
                if (Math.abs(c = b + an / c) < Constants.QL_EPSILON) {
                    c = Constants.QL_EPSILON;
                }
                d = 1.0 / d;
                double del = d * c;
                h *= del;
                if (!(Math.abs(del - 1.0) < Constants.QL_EPSILON)) continue;
                return h * Math.exp(-x + this.a * Math.log(x) - gln);
            }
        }
        throw new ArithmeticException(ACCURACY_NOT_REACHED);
    }
}

