/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Constants;
import org.jquantlib.math.ErrorFunction;
import org.jquantlib.math.Ops;
import org.jquantlib.math.distributions.NormalDistribution;

public class CumulativeNormalDistribution
extends NormalDistribution
implements Ops.DoubleOp {
    private static final ErrorFunction errorFunction = new ErrorFunction();
    private static final NormalDistribution gaussian = new NormalDistribution();

    public CumulativeNormalDistribution() {
    }

    public CumulativeNormalDistribution(double average, double sigma) {
        super(average, sigma);
    }

    @Override
    public double op(double z) {
        double result = 0.5 * (1.0 + errorFunction.op((z = (z - this.average) / this.sigma) * 0.7071067811865476));
        if (result <= 1.0E-8) {
            double lasta;
            double sum = 1.0;
            double zsqr = z * z;
            double i = 1.0;
            double g = 1.0;
            double a = Double.MAX_VALUE;
            do {
                lasta = a;
                double x = (4.0 * i - 3.0) / zsqr;
                double y = x * ((4.0 * i - 1.0) / zsqr);
                a = g * (x - y);
                sum -= a;
                g *= y;
                i += 1.0;
            } while (lasta > (a = Math.abs(a)) && a >= Math.abs(sum * Constants.QL_EPSILON));
            result = -gaussian.op(z) / z * sum;
        }
        return result;
    }

    @Override
    public double derivative(double x) {
        double xn = (x - this.average) / this.sigma;
        return gaussian.op(xn) / this.sigma;
    }
}

