/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.legacy.libormarkets;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.PseudoSqrt;
import org.jquantlib.model.Parameter;

public abstract class LmCorrelationModel {
    protected int size_;
    protected List<Parameter> arguments_;

    public LmCorrelationModel(int size, int nArguments) {
        this.size_ = size;
        this.arguments_ = new ArrayList<Parameter>(nArguments);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public int size() {
        return this.size_;
    }

    public int factors() {
        return this.size_;
    }

    public boolean isTimeIndependent() {
        return false;
    }

    public Matrix pseudoSqrt(double t, Array x) {
        return PseudoSqrt.pseudoSqrt(this.correlation(t, x), PseudoSqrt.SalvagingAlgorithm.Spectral);
    }

    public double correlation(int i, int j, double t, Array x) {
        return this.correlation(t, x).get(i, j);
    }

    public double correlation(int i, int j, double t) {
        return this.correlation(t, new Array(j)).get(i, j);
    }

    public abstract Matrix correlation(double var1, Array var3);

    public Matrix correlation(double t) {
        return this.correlation(t, new Array(0));
    }

    public List<Parameter> params() {
        return this.arguments_;
    }

    public void setParams(List<Parameter> arguments) {
        this.arguments_ = arguments;
        this.generateArguments();
    }

    protected abstract void generateArguments();
}

