/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments.bonds;

import org.jquantlib.instruments.Bond;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;

public class ZeroCouponBond
extends Bond {
    public ZeroCouponBond(int settlementDays, Calendar calendar, double faceAmount, Date maturityDate, BusinessDayConvention paymentConvention, double redemption, Date issueDate) {
        super(settlementDays, calendar, issueDate);
        this.maturityDate_ = maturityDate.clone();
        Date redemptionDate = this.calendar_.adjust(maturityDate, paymentConvention);
        this.setSingleRedemption(faceAmount, redemption, redemptionDate);
    }

    public ZeroCouponBond(int settlementDays, Calendar calendar, double faceAmount, Date maturityDate) {
        this(settlementDays, calendar, faceAmount, maturityDate, BusinessDayConvention.Following, 100.0, new Date());
    }

    public ZeroCouponBond(int settlementDays, Calendar calendar, double faceAmount, Date maturityDate, BusinessDayConvention paymentConvention, double redemption) {
        this(settlementDays, calendar, faceAmount, maturityDate, paymentConvention, redemption, new Date());
    }

    public ZeroCouponBond(int settlementDays, Calendar calendar, double faceAmount, Date maturityDate, BusinessDayConvention paymentConvention) {
        this(settlementDays, calendar, faceAmount, maturityDate, paymentConvention, 100.0, new Date());
    }
}

