/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments.bonds;

import org.jquantlib.QL;
import org.jquantlib.cashflow.CmsLeg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.SwapIndex;
import org.jquantlib.instruments.Bond;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class CmsRateBond
extends Bond {
    public CmsRateBond(int settlementDays, double faceAmount, Schedule schedule, SwapIndex index, DayCounter paymentDayCounter, BusinessDayConvention paymentConvention, int fixingDays, Array gearings, Array spreads, Array caps, Array floors, boolean inArrears, double redemption, Date issueDate) {
        super(settlementDays, schedule.calendar(), issueDate);
        this.maturityDate_ = schedule.endDate().clone();
        this.cashflows_ = new CmsLeg(schedule, index).withNotionals(faceAmount).withPaymentDayCounter(paymentDayCounter).withPaymentAdjustment(paymentConvention).withFixingDays(fixingDays).withGearings(gearings).withSpreads(spreads).withCaps(caps).withFloors(floors).inArrears(inArrears).Leg();
        this.addRedemptionsToCashflows(new double[]{redemption});
        QL.ensure(!this.cashflows().isEmpty(), "bond with no cashflows!");
        QL.ensure(this.redemptions_.size() == 1, "multiple redemptions created");
        index.addObserver(this);
    }

    public CmsRateBond(int settlementDays, double faceAmount, Schedule schedule, SwapIndex index, DayCounter paymentDayCounter) {
        this(settlementDays, faceAmount, schedule, index, paymentDayCounter, BusinessDayConvention.Following, 0, new Array(1).fill(1.0), new Array(1).fill(0.0), new Array(0), new Array(0), false, 100.0, new Date());
    }
}

