/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.CashFlows;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.pricingengines.GenericEngine;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.time.Date;

public class Swap
extends Instrument {
    protected List<Leg> legs;
    protected double[] payer;
    protected double[] legNPV;
    protected double[] legBPS;

    public Swap(Leg firstLeg, Leg secondLeg) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.legs = new ArrayList<Leg>();
        this.payer = new double[2];
        this.legNPV = new double[2];
        this.legBPS = new double[2];
        this.legs.add(firstLeg);
        this.legs.add(secondLeg);
        this.payer[0] = -1.0;
        this.payer[1] = 1.0;
        for (int i = 0; i < this.legs.size(); ++i) {
            for (CashFlow item : this.legs.get(i)) {
                item.addObserver(this);
            }
        }
    }

    public Swap(List<Leg> legs, boolean[] payer) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.legs = legs;
        this.payer = new double[legs.size()];
        Arrays.fill(this.payer, 1.0);
        this.legNPV = new double[legs.size()];
        this.legBPS = new double[legs.size()];
        for (int j = 0; j < this.legs.size(); ++j) {
            if (payer[j]) {
                this.payer[j] = -1.0;
            }
            for (int i = 0; i < legs.size(); ++i) {
                for (CashFlow item : legs.get(i)) {
                    item.addObserver(this);
                }
            }
        }
    }

    protected Swap(int legs) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.legs = new ArrayList<Leg>();
        this.payer = new double[legs];
        this.legNPV = new double[legs];
        this.legBPS = new double[legs];
    }

    public Date startDate() {
        QL.require(this.legs.size() > 0, "no legs given");
        Date d = CashFlows.getInstance().startDate(this.legs.get(0));
        for (int j = 1; j < this.legs.size(); ++j) {
            d = Date.min(d, CashFlows.getInstance().startDate(this.legs.get(j)));
        }
        return d;
    }

    public Date maturityDate() {
        QL.require(this.legs.size() > 0, "no legs given");
        Date d = CashFlows.getInstance().maturityDate(this.legs.get(0));
        for (int j = 1; j < this.legs.size(); ++j) {
            d = Date.max(d, CashFlows.getInstance().maturityDate(this.legs.get(j)));
        }
        return d;
    }

    @Override
    public boolean isExpired() {
        Date today = new Settings().evaluationDate();
        for (int i = 0; i < this.legs.size(); ++i) {
            for (CashFlow item : this.legs.get(i)) {
                if (item.hasOccurred(today)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void setupExpired() {
        super.setupExpired();
        Arrays.fill(this.legBPS, 0.0);
        Arrays.fill(this.legNPV, 0.0);
    }

    @Override
    public void setupArguments(PricingEngine.Arguments arguments) {
        ArgumentsImpl a = (ArgumentsImpl)arguments;
        a.legs = this.legs;
        a.payer = this.payer;
    }

    @Override
    public void fetchResults(PricingEngine.Results results) {
        super.fetchResults(results);
        ResultsImpl r = (ResultsImpl)results;
        if (r.legNPV.length > 0) {
            QL.require(r.legNPV.length == this.legNPV.length, "wrong number of leg NPV returned");
            this.legNPV = r.legNPV;
        } else {
            Arrays.fill(this.legNPV, Double.MAX_VALUE);
        }
        if (r.legBPS.length > 0) {
            QL.require(r.legBPS.length == this.legBPS.length, "wrong number of leg BPS returned");
            this.legBPS = r.legBPS;
        } else {
            Arrays.fill(this.legBPS, Double.MAX_VALUE);
        }
    }

    public static class EngineImpl
    extends GenericEngine<Arguments, Results> {
        protected EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
        }

        @Override
        public void calculate() {
        }
    }

    public static class ResultsImpl
    extends Instrument.ResultsImpl
    implements Results {
        public double[] legNPV;
        public double[] legBPS;

        @Override
        public void reset() {
            super.reset();
            if (this.legNPV != null) {
                Arrays.fill(this.legNPV, 0.0);
            }
            if (this.legBPS != null) {
                Arrays.fill(this.legBPS, 0.0);
            }
        }
    }

    public static class ArgumentsImpl
    implements Arguments {
        public List<Leg> legs;
        public double[] payer;

        @Override
        public void validate() {
            QL.require(this.legs.size() == this.payer.length, "number of legs and multipliers differ");
        }
    }

    public static interface Results
    extends Instrument.Results {
    }

    public static interface Arguments
    extends Instrument.Arguments {
    }
}

