/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class PlainVanillaPayoff
extends StrikedTypePayoff {
    public PlainVanillaPayoff(Option.Type type, double strike) {
        super(type, strike);
    }

    @Override
    public String name() {
        return "Vanilla";
    }

    @Override
    public final double get(double price) {
        if (this.type == Option.Type.Call) {
            return Math.max(price - this.strike, 0.0);
        }
        if (this.type == Option.Type.Put) {
            return Math.max(this.strike - price, 0.0);
        }
        throw new LibraryException("unknown option type");
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

