/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Frequency;

public abstract class Option
extends Instrument {
    protected final Payoff payoff;
    protected final Exercise exercise;

    public Option(Payoff payoff, Exercise exercise) {
        this.payoff = payoff;
        this.exercise = exercise;
    }

    @Override
    protected void setupArguments(PricingEngine.Arguments a) {
        QL.require(ArgumentsImpl.class.isAssignableFrom(a.getClass()), "Unexpected type for type parameter");
        ArgumentsImpl arguments = (ArgumentsImpl)a;
        arguments.payoff = this.payoff;
        arguments.exercise = this.exercise;
    }

    public static class MoreGreeksImpl
    implements MoreGreeks {
        public double itmCashProbability;
        public double deltaForward;
        public double elasticity;
        public double thetaPerDay;
        public double strikeSensitivity;

        @Override
        public void reset() {
            this.strikeSensitivity = Double.NaN;
            this.thetaPerDay = Double.NaN;
            this.elasticity = Double.NaN;
            this.deltaForward = Double.NaN;
            this.itmCashProbability = Double.NaN;
        }
    }

    public static class GreeksImpl
    implements Greeks {
        public double delta;
        public double gamma;
        public double theta;
        public double vega;
        public double rho;
        public double dividendRho;

        public double blackScholesTheta(GeneralizedBlackScholesProcess p, double value, double delta, double gamma) {
            double u = p.stateVariable().currentLink().value();
            double r = p.riskFreeRate().currentLink().zeroRate(0.0, Compounding.Continuous, Frequency.Annual, false).rate();
            double q = p.dividendYield().currentLink().zeroRate(0.0, Compounding.Continuous, Frequency.Annual, false).rate();
            double v = p.localVolatility().currentLink().localVol(0.0, u);
            return r * value - (r - q) * u * delta - 0.5 * v * v * u * u * gamma;
        }

        public double defaultThetaPerDay(double theta) {
            return theta / 365.0;
        }

        @Override
        public void reset() {
            this.dividendRho = Double.NaN;
            this.rho = Double.NaN;
            this.vega = Double.NaN;
            this.theta = Double.NaN;
            this.gamma = Double.NaN;
            this.delta = Double.NaN;
        }
    }

    public static class ArgumentsImpl
    implements Arguments {
        public Payoff payoff;
        public Exercise exercise;

        @Override
        public void validate() {
            QL.require(this.payoff != null, "No payoff given");
            QL.require(this.exercise != null, "No exercise given");
        }
    }

    public static interface MoreGreeks
    extends Instrument.Results {
    }

    public static interface Greeks
    extends Instrument.Results {
    }

    public static interface Arguments
    extends Instrument.Arguments {
    }

    public static enum Type {
        Put(-1),
        Call(1);

        private int value;
        public static final String UNKNOWN_OPTION_TYPE = "unknown option type";

        private Type(int type) {
            this.value = type;
        }

        public int toInteger() {
            return this.value;
        }

        public String toString() {
            if (this.value == 1) {
                return "Call";
            }
            if (this.value == -1) {
                return "Put";
            }
            throw new LibraryException(UNKNOWN_OPTION_TYPE);
        }
    }
}

