/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.daycounters.Thirty360;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.instruments.VanillaSwap;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.swap.DiscountingSwapEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;

public class MakeVanillaSwap {
    private final Period swapTenor;
    private final IborIndex iborIndex;
    private final double fixedRate;
    private final Period forwardStart;
    private Date effectiveDate;
    private Calendar fixedCalendar;
    private Calendar floatCalendar;
    private VanillaSwap.Type type;
    private double nominal;
    private Period fixedTenor;
    private Period floatTenor;
    private BusinessDayConvention fixedConvention;
    private BusinessDayConvention fixedTerminationDateConvention;
    private BusinessDayConvention floatConvention;
    private BusinessDayConvention floatTerminationDateConvention;
    private DateGeneration.Rule fixedRule;
    private DateGeneration.Rule floatRule;
    private boolean fixedEndOfMonth;
    private boolean floatEndOfMonth;
    private Date fixedFirstDate;
    private Date fixedNextToLastDate;
    private Date floatFirstDate;
    private Date floatNextToLastDate;
    private double floatSpread;
    private DayCounter fixedDayCount;
    private DayCounter floatDayCount;
    private Date terminationDate;
    private PricingEngine engine;

    public MakeVanillaSwap(Period swapTenor, IborIndex index) {
        this(swapTenor, index, 0.0, new Period(0, TimeUnit.Days));
    }

    public MakeVanillaSwap(Period swapTenor, IborIndex index, double fixedRate) {
        this(swapTenor, index, fixedRate, new Period(0, TimeUnit.Days));
    }

    public MakeVanillaSwap(Period swapTenor, IborIndex index, double fixedRate, Period forwardStart) {
        this.swapTenor = swapTenor;
        this.iborIndex = index;
        this.fixedRate = fixedRate;
        this.forwardStart = forwardStart;
        this.effectiveDate = new Date();
        this.fixedCalendar = index.fixingCalendar();
        this.floatCalendar = index.fixingCalendar();
        this.type = VanillaSwap.Type.Payer;
        this.nominal = 1.0;
        this.fixedTenor = new Period(1, TimeUnit.Years);
        this.floatTenor = index.tenor();
        this.fixedConvention = BusinessDayConvention.ModifiedFollowing;
        this.fixedTerminationDateConvention = BusinessDayConvention.ModifiedFollowing;
        this.floatConvention = index.businessDayConvention();
        this.floatTerminationDateConvention = index.businessDayConvention();
        this.fixedRule = DateGeneration.Rule.Backward;
        this.floatRule = DateGeneration.Rule.Backward;
        this.fixedEndOfMonth = false;
        this.floatEndOfMonth = false;
        this.fixedFirstDate = new Date();
        this.fixedNextToLastDate = new Date();
        this.floatFirstDate = new Date();
        this.floatNextToLastDate = new Date();
        this.floatSpread = 0.0;
        this.fixedDayCount = new Thirty360();
        this.floatDayCount = index.dayCounter();
        this.engine = new DiscountingSwapEngine(index.termStructure());
    }

    public VanillaSwap value() {
        Date startDate;
        QL.validateExperimentalMode();
        if (!this.effectiveDate.isNull()) {
            startDate = this.effectiveDate;
        } else {
            int fixingDays = this.iborIndex.fixingDays();
            Date referenceDate = new Settings().evaluationDate();
            Date spotDate = this.floatCalendar.advance(referenceDate, fixingDays, TimeUnit.Days);
            startDate = spotDate.add(this.forwardStart);
        }
        Date endDate = this.terminationDate != null && !this.terminationDate.isNull() ? this.terminationDate : startDate.add(this.swapTenor);
        Schedule fixedSchedule = new Schedule(startDate, endDate, this.fixedTenor, this.fixedCalendar, this.fixedConvention, this.fixedTerminationDateConvention, this.fixedRule, this.fixedEndOfMonth, this.fixedFirstDate, this.fixedNextToLastDate);
        Schedule floatSchedule = new Schedule(startDate, endDate, this.floatTenor, this.floatCalendar, this.floatConvention, this.floatTerminationDateConvention, this.floatRule, this.floatEndOfMonth, this.floatFirstDate, this.floatNextToLastDate);
        double usedFixedRate = this.fixedRate;
        if (Double.isNaN(this.fixedRate)) {
            QL.require(!this.iborIndex.termStructure().empty(), "no forecasting term structure set to " + this.iborIndex.name());
            VanillaSwap temp = new VanillaSwap(this.type, this.nominal, fixedSchedule, 0.0, this.fixedDayCount, floatSchedule, this.iborIndex, this.floatSpread, this.floatDayCount, BusinessDayConvention.Following);
            temp.setPricingEngine(new DiscountingSwapEngine(this.iborIndex.termStructure()));
            usedFixedRate = temp.fairRate();
        }
        VanillaSwap swap = new VanillaSwap(this.type, this.nominal, fixedSchedule, usedFixedRate, this.fixedDayCount, floatSchedule, this.iborIndex, this.floatSpread, this.floatDayCount, BusinessDayConvention.Following);
        swap.setPricingEngine(this.engine);
        return swap;
    }

    public MakeVanillaSwap receiveFixed(boolean flag) {
        this.type = flag ? VanillaSwap.Type.Receiver : VanillaSwap.Type.Payer;
        return this;
    }

    public MakeVanillaSwap withType(VanillaSwap.Type type) {
        this.type = type;
        return this;
    }

    public MakeVanillaSwap withNominal(double n) {
        this.nominal = n;
        return this;
    }

    public MakeVanillaSwap withEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    public MakeVanillaSwap withTerminationDate(Date terminationDate) {
        this.terminationDate = terminationDate;
        return this;
    }

    public MakeVanillaSwap withRule(DateGeneration.Rule r) {
        this.fixedRule = r;
        this.floatRule = r;
        return this;
    }

    public MakeVanillaSwap withDiscountingTermStructure(Handle<YieldTermStructure> discountingTermStructure) {
        this.engine = new DiscountingSwapEngine(discountingTermStructure);
        return this;
    }

    public MakeVanillaSwap withFixedLegTenor(Period t) {
        this.fixedTenor = t;
        return this;
    }

    public MakeVanillaSwap withFixedLegCalendar(Calendar cal) {
        this.fixedCalendar = cal;
        return this;
    }

    public MakeVanillaSwap withFixedLegConvention(BusinessDayConvention bdc) {
        this.fixedConvention = bdc;
        return this;
    }

    public MakeVanillaSwap withFixedLegTerminationDateConvention(BusinessDayConvention bdc) {
        this.fixedTerminationDateConvention = bdc;
        return this;
    }

    public MakeVanillaSwap withFixedLegRule(DateGeneration.Rule r) {
        this.fixedRule = r;
        return this;
    }

    public MakeVanillaSwap withFixedLegEndOfMonth(boolean flag) {
        this.fixedEndOfMonth = flag;
        return this;
    }

    public MakeVanillaSwap withFixedLegFirstDate(Date d) {
        this.fixedFirstDate = d;
        return this;
    }

    public MakeVanillaSwap withFixedLegNextToLastDate(Date d) {
        this.fixedNextToLastDate = d;
        return this;
    }

    public MakeVanillaSwap withFixedLegDayCount(DayCounter dc) {
        this.fixedDayCount = dc;
        return this;
    }

    public MakeVanillaSwap withFloatingLegTenor(Period t) {
        this.floatTenor = t;
        return this;
    }

    public MakeVanillaSwap withFloatingLegCalendar(Calendar cal) {
        this.floatCalendar = cal;
        return this;
    }

    public MakeVanillaSwap withFloatingLegConvention(BusinessDayConvention bdc) {
        this.floatConvention = bdc;
        return this;
    }

    public MakeVanillaSwap withFloatingLegTerminationDateConvention(BusinessDayConvention bdc) {
        this.floatTerminationDateConvention = bdc;
        return this;
    }

    public MakeVanillaSwap withFloatingLegRule(DateGeneration.Rule r) {
        this.floatRule = r;
        return this;
    }

    public MakeVanillaSwap withFloatingLegEndOfMonth(boolean flag) {
        this.floatEndOfMonth = flag;
        return this;
    }

    public MakeVanillaSwap withFloatingLegFirstDate(Date d) {
        this.floatFirstDate = d;
        return this;
    }

    public MakeVanillaSwap withFloatingLegNextToLastDate(Date d) {
        this.floatNextToLastDate = d;
        return this;
    }

    public MakeVanillaSwap withFloatingLegDayCount(DayCounter dc) {
        this.floatDayCount = dc;
        return this;
    }

    public MakeVanillaSwap withFloatingLegSpread(double sp) {
        this.floatSpread = sp;
        return this;
    }
}

