/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.HashMap;
import java.util.Map;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.util.LazyObject;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Femi Anthony"})
public abstract class Instrument
extends LazyObject {
    private static final String SHOULD_DEFINE_PRICING_ENGINE = "Should define pricing engine";
    private static final String SETUP_ARGUMENTS_NOT_IMPLEMENTED = "Instrument#setupArguments() not implemented";
    protected PricingEngine engine;
    protected double NPV = Double.NaN;
    protected double errorEstimate = 0.0;

    public abstract boolean isExpired();

    protected void setupArguments(PricingEngine.Arguments a) {
        throw new LibraryException(SETUP_ARGUMENTS_NOT_IMPLEMENTED);
    }

    protected Instrument() {
    }

    public final void setPricingEngine(PricingEngine engine) {
        if (this.engine != null) {
            this.engine.deleteObserver(this);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.addObserver(this);
        }
        this.update();
    }

    public final double NPV() {
        this.calculate();
        QL.require(!Double.isNaN(this.NPV), "NPV not provided");
        return this.NPV;
    }

    public final double errorEstimate() {
        this.calculate();
        QL.require(!Double.isNaN(this.errorEstimate), "error estimate not provided");
        return this.errorEstimate;
    }

    protected void fetchResults(PricingEngine.Results r) {
        QL.require(PricingEngine.Results.class.isAssignableFrom(r.getClass()), "Unexpected type for type parameter");
        ResultsImpl results = (ResultsImpl)r;
        this.NPV = results.value;
        this.errorEstimate = results.errorEstimate;
    }

    protected void setupExpired() {
        this.NPV = 0.0;
        this.errorEstimate = 0.0;
    }

    @Override
    protected void performCalculations() {
        QL.require(this.engine != null, SHOULD_DEFINE_PRICING_ENGINE);
        this.engine.reset();
        this.setupArguments(this.engine.getArguments());
        this.engine.getArguments().validate();
        this.engine.calculate();
        this.fetchResults(this.engine.getResults());
    }

    @Override
    protected void calculate() {
        if (this.isExpired()) {
            this.setupExpired();
            this.calculated = true;
        } else {
            super.calculate();
        }
    }

    public static class ResultsImpl
    implements Results {
        public double value;
        public double errorEstimate;
        private final Map<String, Object> additionalResults = new HashMap<String, Object>();

        public Object result(String key) {
            return this.additionalResults.get(key);
        }

        public Map<String, Object> additionalResults() {
            return this.additionalResults;
        }

        @Override
        public void reset() {
            this.errorEstimate = Double.NaN;
            this.value = Double.NaN;
            this.additionalResults.clear();
        }
    }

    public static interface Results
    extends PricingEngine.Results {
    }

    public static interface Arguments
    extends PricingEngine.Arguments {
    }
}

