/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.GenericEngine;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.time.Date;

public class DiscreteAveragingAsianOption
extends OneAssetOption {
    protected final AverageType averageType;
    protected final double runningAccumulator;
    protected final int pastFixings;
    protected final List<Date> fixingDates;

    public DiscreteAveragingAsianOption(AverageType averageType, double runningAccumulator, int pastFixings, List<Date> fixingDates, StrikedTypePayoff payoff, Exercise exercise) {
        super(payoff, exercise);
        this.averageType = averageType;
        this.runningAccumulator = runningAccumulator;
        this.pastFixings = pastFixings;
        this.fixingDates = new ArrayList<Date>(fixingDates);
        Collections.sort(this.fixingDates);
    }

    @Override
    public void setupArguments(PricingEngine.Arguments arguments) {
        super.setupArguments(arguments);
        QL.require(OneAssetOption.Arguments.class.isAssignableFrom(arguments.getClass()), "Unexpected type for type parameter");
        ArgumentsImpl a = (ArgumentsImpl)arguments;
        a.averageType = this.averageType;
        a.runningAccumulator = this.runningAccumulator;
        a.pastFixings = this.pastFixings;
        a.fixingDates = this.fixingDates;
    }

    public static abstract class EngineImpl
    extends GenericEngine<OneAssetOption.Arguments, OneAssetOption.Results>
    implements OneAssetOption.Results {
        protected EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
        }
    }

    public static class ResultsImpl
    extends OneAssetOption.ResultsImpl
    implements OneAssetOption.Results {
    }

    public static class ArgumentsImpl
    extends OneAssetOption.ArgumentsImpl
    implements OneAssetOption.Arguments {
        public AverageType averageType = null;
        public double runningAccumulator = Double.MAX_VALUE;
        public int pastFixings = Integer.MAX_VALUE;
        public List<Date> fixingDates = new ArrayList<Date>();

        @Override
        public void validate() {
            super.validate();
            QL.require(this.averageType != null, "unspecified average type");
            QL.require(this.pastFixings != Integer.MAX_VALUE, "null past-fixing number");
            QL.require(!Double.isNaN(this.runningAccumulator), "null running product");
            switch (this.averageType) {
                case Arithmetic: {
                    QL.require(this.runningAccumulator >= 0.0, "non negative running sum required: not allowed");
                    break;
                }
                case Geometric: {
                    QL.require(this.runningAccumulator > 0.0, "positive running product required: not allowed");
                    break;
                }
                default: {
                    throw new LibraryException("invalid average type");
                }
            }
        }
    }
}

