/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class CashOrNothingPayoff
extends StrikedTypePayoff {
    protected double cashPayoff;

    public CashOrNothingPayoff(Option.Type type, double strike, double cashPayoff) {
        super(type, strike);
        this.cashPayoff = cashPayoff;
    }

    public final double getCashPayoff() {
        return this.cashPayoff;
    }

    @Override
    public String name() {
        return "CashOrNothing";
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.description()).append(", ").append(this.cashPayoff).append(" cash payoff");
        return sb.toString();
    }

    @Override
    public final double get(double price) {
        if (this.type == Option.Type.Call) {
            return price - this.strike > 0.0 ? this.cashPayoff : 0.0;
        }
        if (this.type == Option.Type.Put) {
            return this.strike - price > 0.0 ? this.cashPayoff : 0.0;
        }
        throw new LibraryException("unknown option type");
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

