/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.cashflow.AverageBMALeg;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.IborLeg;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.BMAIndex;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.instruments.Swap;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Schedule;

public class BMASwap
extends Swap {
    static final double basisPoint = 1.0E-4;
    private final Type type;
    private final double nominal;
    private final double liborFraction;
    private final double liborSpread;

    public BMASwap(Type type, double nominal, Schedule liborSchedule, double liborFraction, double liborSpread, IborIndex liborIndex, DayCounter liborDayCount, Schedule bmaSchedule, BMAIndex bmaIndex, DayCounter bmaDayCount) {
        super(2);
        this.type = type;
        this.nominal = nominal;
        this.liborFraction = liborFraction;
        this.liborSpread = liborSpread;
        BusinessDayConvention convention = liborSchedule.businessDayConvention();
        Leg iborLeg = new IborLeg(liborSchedule, liborIndex).withNotionals(nominal).withPaymentDayCounter(liborDayCount).withPaymentAdjustment(convention).withFixingDays(liborIndex.fixingDays()).withGearings(liborFraction).withSpreads(liborSpread).Leg();
        this.legs.add(iborLeg);
        Leg bmaLeg = new AverageBMALeg(bmaSchedule, bmaIndex).withNotionals(nominal).withPaymentDayCounter(bmaDayCount).withPaymentAdjustment(bmaSchedule.businessDayConvention()).Leg();
        this.legs.add(bmaLeg);
        for (Leg leg : this.legs) {
            for (CashFlow item : leg) {
                item.addObserver(this);
            }
        }
        switch (type) {
            case Payer: {
                this.payer[0] = 1.0;
                this.payer[1] = -1.0;
                break;
            }
            case Receiver: {
                this.payer[0] = -1.0;
                this.payer[1] = 1.0;
                break;
            }
            default: {
                throw new LibraryException("Unknown BMA-swap type");
            }
        }
    }

    public double liborFraction() {
        return this.liborFraction;
    }

    public double liborSpread() {
        return this.liborSpread;
    }

    public double nominal() {
        return this.nominal;
    }

    public Type type() {
        return this.type;
    }

    public Leg liborLeg() {
        return (Leg)this.legs.get(0);
    }

    public Leg bmaLeg() {
        return (Leg)this.legs.get(1);
    }

    public double liborLegBPS() {
        this.calculate();
        QL.require(!Double.isNaN(this.legBPS[0]), "result not available");
        return this.legBPS[0];
    }

    public double liborLegNPV() {
        this.calculate();
        QL.require(!Double.isNaN(this.legNPV[0]), "result not available");
        return this.legNPV[0];
    }

    public double fairLiborFraction() {
        double spreadNPV = this.liborSpread / 1.0E-4 * this.liborLegBPS();
        double pureLiborNPV = this.liborLegNPV() - spreadNPV;
        return -this.liborFraction * (this.bmaLegNPV() + spreadNPV) / pureLiborNPV;
    }

    public double fairLiborSpread() {
        return this.liborSpread - this.NPV() / (this.liborLegBPS() / 1.0E-4);
    }

    public double bmaLegBPS() {
        this.calculate();
        QL.require(!Double.isNaN(this.legBPS[1]), "result not available");
        return this.legBPS[1];
    }

    public double bmaLegNPV() {
        this.calculate();
        QL.require(!Double.isNaN(this.legNPV[1]), "result not available");
        return this.legNPV[1];
    }

    public static enum Type {
        Receiver(-1),
        Payer(1);

        private final int enumValue;

        private Type(int frequency) {
            this.enumValue = frequency;
        }

        public static Type valueOf(int value) {
            switch (value) {
                case -1: {
                    return Receiver;
                }
                case 1: {
                    return Payer;
                }
            }
            throw new LibraryException("value must be one of -1, 1");
        }

        public int toInteger() {
            return this.enumValue;
        }
    }
}

