/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import org.jquantlib.currencies.Currency;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.instruments.MakeVanillaSwap;
import org.jquantlib.instruments.VanillaSwap;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;

public class SwapIndex
extends InterestRateIndex {
    protected Period tenor;
    protected IborIndex iborIndex;
    protected Period fixedLegTenor;
    protected BusinessDayConvention fixedLegConvention;

    public SwapIndex(String familyName, Period tenor, int settlementDays, Currency currency, Calendar calendar, Period fixedLegTenor, BusinessDayConvention fixedLegConvention, DayCounter fixedLegDayCounter, IborIndex iborIndex) {
        super(familyName, tenor, settlementDays, currency, calendar, fixedLegDayCounter);
        this.tenor = tenor;
        this.iborIndex = iborIndex;
        this.fixedLegTenor = fixedLegTenor;
        this.fixedLegConvention = fixedLegConvention;
        this.iborIndex.addObserver(this);
    }

    @Override
    protected double forecastFixing(Date fixingDate) {
        return this.underlyingSwap(fixingDate).fairRate();
    }

    public IborIndex iborIndex() {
        return this.iborIndex;
    }

    public Period fixedLegTenor() {
        return this.fixedLegTenor;
    }

    public BusinessDayConvention fixedLegConvention() {
        return this.fixedLegConvention;
    }

    public VanillaSwap underlyingSwap(Date fixingDate) {
        double fixedRate = 0.0;
        return new MakeVanillaSwap(this.tenor, this.iborIndex, 0.0).withEffectiveDate(this.valueDate(fixingDate)).withFixedLegCalendar(this.fixingCalendar()).withFixedLegDayCount(this.dayCounter).withFixedLegTenor(this.fixedLegTenor).withFixedLegConvention(this.fixedLegConvention).withFixedLegTerminationDateConvention(this.fixedLegConvention).value();
    }

    @Override
    public Date maturityDate(Date valueDate) {
        Date fixDate = this.fixingDate(valueDate);
        return this.underlyingSwap(fixDate).maturityDate();
    }

    @Override
    public Handle<YieldTermStructure> termStructure() {
        return this.iborIndex.termStructure();
    }
}

