/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.experimental.lattices;

import org.jquantlib.experimental.lattices.ExtendedBinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public abstract class ExtendedEqualJumpsBinomialTree
extends ExtendedBinomialTree {
    protected double dx;
    protected double pu;
    protected double pd;

    public ExtendedEqualJumpsBinomialTree(StochasticProcess1D process, double end, int steps) {
        super(process, end, steps);
    }

    @Override
    public double underlying(int i, int index) {
        double stepTime = (double)i * this.dt;
        long j = 2 * index - i;
        return this.x0 * Math.exp((double)j * this.dxStep(stepTime));
    }

    @Override
    public double probability(int i, int ref, int branch) {
        double stepTime = (double)i * this.dt;
        double upProb = this.probUp(stepTime);
        double downProb = 1.0 - upProb;
        return branch == 1 ? upProb : downProb;
    }

    protected abstract double probUp(double var1);

    protected abstract double dxStep(double var1);
}

