/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.cashflow.Dividend;
import org.jquantlib.time.Date;

public class FractionalDividend
extends Dividend {
    protected double rate;
    protected double nominal;

    public FractionalDividend(double rate, Date date) {
        super(date);
        this.rate = rate;
    }

    public FractionalDividend(double rate, double nominal, Date date) {
        super(date);
        this.rate = rate;
        this.nominal = nominal;
    }

    @Override
    public double amount(double underlying) {
        return this.rate * underlying;
    }

    @Override
    public double amount() {
        QL.require(!Double.isNaN(this.nominal), "no nominal given");
        return this.rate * this.nominal;
    }
}

