/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.cashflow.FixedRateCoupon;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class FixedRateLeg
extends Leg {
    private final Schedule schedule_;
    private double[] notionals_;
    private InterestRate[] couponRates_;
    private final DayCounter paymentDayCounter_;
    private DayCounter firstPeriodDayCounter_;
    private BusinessDayConvention paymentAdjustment_;

    public FixedRateLeg(Schedule schedule, DayCounter paymentDayCounter) {
        this.schedule_ = schedule;
        this.paymentDayCounter_ = paymentDayCounter;
        this.paymentAdjustment_ = BusinessDayConvention.Following;
    }

    public FixedRateLeg withNotionals(double notional) {
        this.notionals_ = new double[]{notional};
        return this;
    }

    public FixedRateLeg withNotionals(double[] notionals) {
        this.notionals_ = notionals;
        return this;
    }

    public FixedRateLeg withCouponRates(double couponRate) {
        this.couponRates_ = new InterestRate[]{new InterestRate(couponRate, this.paymentDayCounter_, Compounding.Simple)};
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        return this;
    }

    public FixedRateLeg withCouponRates(InterestRate couponRate) {
        this.couponRates_ = new InterestRate[]{couponRate};
        return this;
    }

    public FixedRateLeg withCouponRates(double[] couponRates) {
        this.couponRates_ = new InterestRate[couponRates.length];
        for (int i = 0; i < couponRates.length; ++i) {
            this.couponRates_[i] = new InterestRate(couponRates[i], this.paymentDayCounter_, Compounding.Simple);
        }
        return this;
    }

    public FixedRateLeg withCouponRates(InterestRate[] couponRates) {
        this.couponRates_ = couponRates;
        return this;
    }

    public FixedRateLeg withPaymentAdjustment(BusinessDayConvention convention) {
        this.paymentAdjustment_ = convention;
        return this;
    }

    public FixedRateLeg withFirstPeriodDayCounter(DayCounter dayCounter) {
        this.firstPeriodDayCounter_ = dayCounter;
        return this;
    }

    public Leg Leg() {
        QL.require(this.couponRates_ != null && this.couponRates_.length > 0, "coupon rates not specified");
        QL.require(this.notionals_ != null && this.notionals_.length > 0, "nominals not specified");
        Leg leg = new Leg();
        Calendar calendar = this.schedule_.calendar();
        Date start = this.schedule_.date(0);
        Date end = this.schedule_.date(1);
        Date paymentDate = calendar.adjust(end, this.paymentAdjustment_);
        InterestRate rate = this.couponRates_[0];
        double nominal = this.notionals_[0];
        if (this.schedule_.isRegular(1)) {
            QL.require(this.firstPeriodDayCounter_ == null || !this.firstPeriodDayCounter_.equals(this.paymentDayCounter_), "regular first coupon does not allow a first-period day count");
            leg.add(new FixedRateCoupon(nominal, paymentDate, rate, this.paymentDayCounter_, start, end, start, end));
        } else {
            Date ref = end.sub(this.schedule_.tenor());
            ref = calendar.adjust(ref, this.schedule_.businessDayConvention());
            DayCounter dc = this.firstPeriodDayCounter_ == null ? this.paymentDayCounter_ : this.firstPeriodDayCounter_;
            leg.add(new FixedRateCoupon(nominal, paymentDate, rate, dc, start, end, ref, end));
        }
        for (int i = 2; i < this.schedule_.size() - 1; ++i) {
            start = end;
            end = this.schedule_.date(i);
            paymentDate = calendar.adjust(end, this.paymentAdjustment_);
            rate = i - 1 < this.couponRates_.length ? this.couponRates_[i - 1] : this.couponRates_[this.couponRates_.length - 1];
            nominal = i - 1 < this.notionals_.length ? this.notionals_[i - 1] : this.notionals_[this.notionals_.length - 1];
            leg.add(new FixedRateCoupon(nominal, paymentDate, rate, this.paymentDayCounter_, start, end, start, end));
        }
        if (this.schedule_.size() > 2) {
            int N = this.schedule_.size();
            start = end;
            end = this.schedule_.date(N - 1);
            paymentDate = calendar.adjust(end, this.paymentAdjustment_);
            rate = N - 2 < this.couponRates_.length ? this.couponRates_[N - 2] : this.couponRates_[this.couponRates_.length - 1];
            nominal = N - 2 < this.notionals_.length ? this.notionals_[N - 2] : this.notionals_[this.notionals_.length - 1];
            if (this.schedule_.isRegular(N - 1)) {
                leg.add(new FixedRateCoupon(nominal, paymentDate, rate, this.paymentDayCounter_, start, end, start, end));
            } else {
                Date ref = start.add(this.schedule_.tenor());
                ref = calendar.adjust(ref, this.schedule_.businessDayConvention());
                leg.add(new FixedRateCoupon(nominal, paymentDate, rate, this.paymentDayCounter_, start, end, start, ref));
            }
        }
        return leg;
    }
}

