/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.cashflow.CappedFlooredCmsCoupon;
import org.jquantlib.cashflow.CmsCoupon;
import org.jquantlib.cashflow.FloatingLeg;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.SwapIndex;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Schedule;

public class CmsLeg {
    private final Schedule schedule_;
    private final SwapIndex swapIndex_;
    private Array notionals_;
    private DayCounter paymentDayCounter_;
    private BusinessDayConvention paymentAdjustment_;
    private Array fixingDays_;
    private Array gearings_;
    private Array spreads_;
    private Array caps_;
    private Array floors_;
    private boolean inArrears_;
    private boolean zeroPayments_;

    public CmsLeg(Schedule schedule, SwapIndex swapIndex) {
        this.schedule_ = schedule;
        this.swapIndex_ = swapIndex;
        this.paymentAdjustment_ = BusinessDayConvention.Following;
        this.inArrears_ = false;
        this.zeroPayments_ = false;
        this.fixingDays_ = new Array(0);
        this.gearings_ = new Array(0);
        this.spreads_ = new Array(0);
        this.caps_ = new Array(0);
        this.floors_ = new Array(0);
    }

    public CmsLeg withNotionals(double notional) {
        this.notionals_ = new Array(1).fill(notional);
        return this;
    }

    public CmsLeg withNotionals(Array notionals) {
        this.notionals_ = notionals;
        return this;
    }

    public CmsLeg withPaymentDayCounter(DayCounter dayCounter) {
        this.paymentDayCounter_ = dayCounter;
        return this;
    }

    public CmsLeg withPaymentAdjustment(BusinessDayConvention convention) {
        this.paymentAdjustment_ = convention;
        return this;
    }

    public CmsLeg withFixingDays(int fixingDays) {
        this.fixingDays_ = new Array(1).fill(fixingDays);
        return this;
    }

    public CmsLeg withFixingDays(Array fixingDays) {
        this.fixingDays_ = fixingDays.clone();
        return this;
    }

    public CmsLeg withGearings(double gearing) {
        this.gearings_ = new Array(1).fill(gearing);
        return this;
    }

    public CmsLeg withGearings(Array gearings) {
        this.gearings_ = gearings.clone();
        return this;
    }

    public CmsLeg withSpreads(double spread) {
        this.spreads_ = new Array(1).fill(spread);
        return this;
    }

    public CmsLeg withSpreads(Array spreads) {
        this.spreads_ = spreads.clone();
        return this;
    }

    public CmsLeg withCaps(double cap) {
        this.caps_ = new Array(1).fill(cap);
        return this;
    }

    public CmsLeg withCaps(Array caps) {
        this.caps_ = caps.clone();
        return this;
    }

    public CmsLeg withFloors(double floor) {
        this.floors_ = new Array(1).fill(floor);
        return this;
    }

    public CmsLeg withFloors(Array floors) {
        this.floors_ = floors.clone();
        return this;
    }

    public CmsLeg inArrears(boolean flag) {
        this.inArrears_ = flag;
        return this;
    }

    public CmsLeg withZeroPayments(boolean flag) {
        this.zeroPayments_ = flag;
        return this;
    }

    public Leg Leg() {
        return new FloatingLeg(SwapIndex.class, CmsCoupon.class, CappedFlooredCmsCoupon.class, this.notionals_, this.schedule_, this.swapIndex_, this.paymentDayCounter_, this.paymentAdjustment_, this.fixingDays_, this.gearings_, this.spreads_, this.caps_, this.floors_, this.inArrears_, this.zeroPayments_);
    }
}

