/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.cashflow.FloatingRateCouponPricer;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class CappedFlooredCoupon
extends FloatingRateCoupon {
    protected FloatingRateCoupon underlying_;
    protected boolean isCapped_;
    protected boolean isFloored_;
    protected double cap_;
    protected double floor_;

    public CappedFlooredCoupon(FloatingRateCoupon underlying) {
        this(underlying, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public CappedFlooredCoupon(FloatingRateCoupon underlying, double cap, double floor) {
        super(underlying.date(), underlying.nominal, underlying.accrualStartDate(), underlying.accrualEndDate(), underlying.fixingDays(), underlying.index(), underlying.gearing(), underlying.spread(), underlying.referencePeriodStart(), underlying.referencePeriodEnd(), underlying.dayCounter(), underlying.isInArrears());
        this.underlying_ = underlying;
        this.isCapped_ = false;
        this.isFloored_ = false;
        if (this.gearing_ > 0.0) {
            if (!Double.isNaN(cap)) {
                this.isCapped_ = true;
                this.cap_ = cap;
            }
            if (!Double.isNaN(floor)) {
                this.floor_ = floor;
                this.isFloored_ = true;
            }
        } else {
            if (!Double.isNaN(cap)) {
                this.floor_ = cap;
                this.isFloored_ = true;
            }
            if (!Double.isNaN(floor)) {
                this.isCapped_ = true;
                this.cap_ = floor;
            }
        }
        if (this.isCapped_ && this.isFloored_) {
            QL.require(cap >= floor, "cap level less than floor level");
        }
        this.underlying_.addObserver(this);
    }

    @Override
    public void setPricer(FloatingRateCouponPricer pricer) {
        if (this.pricer_ != null) {
            this.pricer_.deleteObserver(this);
        }
        this.pricer_ = pricer;
        if (this.pricer_ != null) {
            this.pricer_.addObserver(this);
        }
        this.update();
        this.underlying_.setPricer(pricer);
    }

    @Override
    public double rate() {
        QL.require(this.underlying_.pricer_ != null, "pricer not set");
        double swapletRate = this.underlying_.rate();
        double floorRate = 0.0;
        double capRate = 0.0;
        if (this.isFloored_) {
            floorRate = this.underlying_.pricer_.floorletRate(this.effectiveFloor());
        }
        if (this.isCapped_) {
            capRate = this.underlying_.pricer_.capletRate(this.effectiveCap());
        }
        return swapletRate + floorRate - capRate;
    }

    @Override
    public double convexityAdjustment() {
        return this.underlying_.convexityAdjustment();
    }

    public boolean isCapped() {
        return this.isCapped_;
    }

    public boolean isFloored() {
        return this.isFloored_;
    }

    public double cap() {
        if (this.gearing_ > 0.0 && this.isCapped_) {
            return this.cap_;
        }
        if (this.gearing_ < 0.0 && this.isFloored_) {
            return this.floor_;
        }
        return Double.MAX_VALUE;
    }

    public double floor() {
        if (this.gearing_ > 0.0 && this.isFloored_) {
            return this.floor_;
        }
        if (this.gearing_ < 0.0 && this.isCapped_) {
            return this.cap_;
        }
        return Double.MAX_VALUE;
    }

    private double effectiveCap() {
        return (this.cap_ - this.spread()) / this.gearing();
    }

    private double effectiveFloor() {
        return (this.floor_ - this.spread()) / this.gearing();
    }

    @Override
    public void update() {
        this.notifyObservers();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

