/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.cashflow.AverageBMACouponPricer;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.BMAIndex;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class AverageBMACoupon
extends FloatingRateCoupon {
    private final Schedule fixingSchedule;
    private static final int bmaCutoffDays = 0;

    public AverageBMACoupon(Date paymentDate, double nominal, Date startDate, Date endDate, BMAIndex index, double gearing, double spread, Date refPeriodStart, Date refPeriodEnd, DayCounter dayCounter) {
        super(paymentDate, nominal, startDate, endDate, index.fixingDays(), index, gearing, spread, refPeriodStart, refPeriodEnd, dayCounter, false);
        this.fixingSchedule = index.fixingSchedule(index.fixingCalendar().advance(startDate, new Period((index.fixingDays() + 0) * -1, TimeUnit.Days), BusinessDayConvention.Preceding), endDate);
        this.setPricer(new AverageBMACouponPricer());
    }

    @Override
    public Date fixingDate() {
        throw new LibraryException("no single fixing for average-BMA coupon");
    }

    public List<Date> fixingDates() {
        return this.fixingSchedule.dates();
    }

    @Override
    public double indexFixing() {
        throw new LibraryException("no single fixing for average-BMA coupon");
    }

    public List<Double> indexFixings() {
        ArrayList<Double> fixings = new ArrayList<Double>(this.fixingSchedule.size());
        for (int i = 0; i < this.fixingSchedule.size(); ++i) {
            fixings.add(this.index_.fixing(this.fixingSchedule.date(i)));
        }
        return fixings;
    }

    @Override
    public double convexityAdjustment() {
        throw new LibraryException("not defined for average-BMA coupon");
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

