/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import sun.misc.Cleaner;

public class UnsignedByteLargeArray
extends LargeArray {
    private static final long serialVersionUID = -5542662641353199195L;
    private byte[] data;

    public UnsignedByteLargeArray(long length) {
        this(length, true);
    }

    public UnsignedByteLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value");
        }
        this.length = length;
        this.allocateMemory(zeroNativeMemory, (short)0, false);
    }

    public UnsignedByteLargeArray(long length, short initValue) {
        this(length, initValue, false);
    }

    public UnsignedByteLargeArray(long length, short initValue, boolean createConstant) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value");
        }
        this.length = length;
        this.allocateMemory(true, initValue, createConstant);
    }

    public UnsignedByteLargeArray(byte[] data) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        this.length = data.length;
        this.data = data;
    }

    public UnsignedByteLargeArray(short[] data) {
        this.type = LargeArrayType.UNSIGNED_BYTE;
        this.length = data.length;
        this.data = new byte[data.length];
        int i = 0;
        while ((long)i < this.length) {
            short elem = data[i];
            if (elem < 0 || elem > 255) {
                throw new IllegalArgumentException("The value cannot be smaller than 0 or greater than 255");
            }
            this.data[i] = (byte)elem;
            ++i;
        }
    }

    @Override
    public UnsignedByteLargeArray clone() {
        return (UnsignedByteLargeArray)super.clone();
    }

    @Override
    public int hashCode(float quality) {
        int fprint = 29 * super.hashCode(quality);
        if (quality > 0.0f) {
            long step = (long)FastMath.ceil((double)((float)(1L - this.length) * quality + (float)this.length));
            for (long i = 0L; i < this.length; i += step) {
                fprint = 31 * fprint + this.getByte(i);
            }
        }
        return fprint;
    }

    @Override
    public boolean equals(Object o) {
        boolean equal;
        if (o == null || !(o instanceof LargeArray)) {
            return false;
        }
        LargeArray la = (LargeArray)o;
        boolean bl = equal = this.type == la.type && this.length == la.length;
        if (!equal) {
            return false;
        }
        if (this.parent != null && la.parent != null ? !this.parent.equals(la.parent) : this.parent != la.parent) {
            return false;
        }
        for (long i = 0L; i < this.length; ++i) {
            if (this.getByte(i) == la.getByte(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Short get(long i) {
        return this.getUnsignedByte(i);
    }

    @Override
    public final Byte getFromNative(long i) {
        return LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
    }

    @Override
    public final boolean getBoolean(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i) != 0;
        }
        if (this.isConstant) {
            return this.data[0] != 0;
        }
        return this.data[(int)i] != 0;
    }

    @Override
    public final byte getByte(long i) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public final short getUnsignedByte(long i) {
        if (this.ptr != 0L) {
            return (short)(0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i));
        }
        if (this.isConstant) {
            return (short)(0xFF & this.data[0]);
        }
        return (short)(0xFF & this.data[(int)i]);
    }

    @Override
    public final short getShort(long i) {
        return this.getUnsignedByte(i);
    }

    @Override
    public final int getInt(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final long getLong(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final float getFloat(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final double getDouble(long i) {
        if (this.ptr != 0L) {
            return 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
        }
        if (this.isConstant) {
            return 0xFF & this.data[0];
        }
        return 0xFF & this.data[(int)i];
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        boolean[] out = a != null && (long)a.length >= len ? a : new boolean[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                byte v = LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
                out[idx++] = v != 0;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0;
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = elem;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                byte v = this.data[(int)i];
                out[idx++] = v != 0;
            }
        }
        return out;
    }

    @Override
    public final boolean[] getBooleanData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        boolean[] out = new boolean[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                byte v = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                out[i] = v != 0;
                ++i;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i] != 0;
                ++i;
            }
        }
        return out;
    }

    public final byte[] getData() {
        return this.data;
    }

    @Override
    public final byte[] getByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        byte[] out = new byte[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            System.arraycopy(this.data, 0, out, 0, (int)this.length);
        }
        return out;
    }

    @Override
    public final byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        byte[] out = a != null && (long)a.length >= len ? a : new byte[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    public final short[] getUnsignedByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)(0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i));
                ++i;
            }
        } else if (this.isConstant) {
            short elem = (short)(0xFF & this.data[0]);
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = (short)(0xFF & this.data[i]);
                ++i;
            }
        }
        return out;
    }

    public final short[] getUnsignedByteData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i));
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & this.data[0]);
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & this.data[(int)i]);
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            short elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i));
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & this.data[0]);
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)(0xFF & this.data[(int)i]);
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        int[] out = new int[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            int elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData(int[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        int[] out = a != null && (long)a.length >= len ? a : new int[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        long[] out = new long[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData(long[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        long[] out = a != null && (long)a.length >= len ? a : new long[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)this.length];
        if (this.ptr != 0L) {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = LargeArrayUtils.UNSAFE.getByte(this.ptr + (long)i);
                ++i;
            }
        } else if (this.isConstant) {
            byte elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[i];
                ++i;
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        double[] out = a != null && (long)a.length >= len ? a : new double[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & LargeArrayUtils.UNSAFE.getByte(this.ptr + i);
            }
        } else if (this.isConstant) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = 0xFF & this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public final void setToNative(long i, Object value) {
        LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (Byte)value);
    }

    @Override
    public final void setBoolean(long i, boolean value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, value ? (byte)1 : 0);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setBoolean(i, value);
        } else {
            this.data[(int)i] = value ? (byte)1 : 0;
        }
    }

    @Override
    public final void setByte(long i, byte value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setByte(i, value);
        } else {
            this.data[(int)i] = value;
        }
    }

    @Override
    public final void setUnsignedByte(long i, short value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("The value cannot be smaller than 0 or greater than 255");
        }
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)value);
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setUnsignedByte(i, value);
        } else {
            this.data[(int)i] = (byte)(0xFF & value);
        }
    }

    @Override
    public final void setShort(long i, short value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFF & value));
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setShort(i, value);
        } else {
            this.data[(int)i] = (byte)(0xFF & value);
        }
    }

    @Override
    public final void setInt(long i, int value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFF & value));
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setInt(i, value);
        } else {
            this.data[(int)i] = (byte)(0xFF & value);
        }
    }

    @Override
    public final void setLong(long i, long value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFFL & value));
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setLong(i, value);
        } else {
            this.data[(int)i] = (byte)(0xFFL & value);
        }
    }

    @Override
    public final void setFloat(long i, float value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFF & (int)value));
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setFloat(i, value);
        } else {
            this.data[(int)i] = (byte)(0xFF & (int)value);
        }
    }

    @Override
    public final void setDouble(long i, double value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + i, (byte)(0xFFL & (long)value));
        } else if (this.isConstant) {
            this.allocateMemory(true, this.getUnsignedByte(0L), false);
            this.isConstant = false;
            this.setDouble(i, value);
        } else {
            this.data[(int)i] = (byte)(0xFFL & (long)value);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.data == null) {
            for (long i = 0L; i < this.length; ++i) {
                out.writeByte(this.getByte(i));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.type != LargeArrayType.UNSIGNED_BYTE) {
            throw new IllegalArgumentException("Invalid array type");
        }
        if (this.data == null) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.type.sizeOf());
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.type.sizeOf()));
            MemoryCounter.increaseCounter(this.length * this.type.sizeOf());
            for (long i = 0L; i < this.length; ++i) {
                this.setByte(i, in.readByte());
            }
        }
    }

    private void allocateMemory(boolean initializeMemory, short initValue, boolean createConstant) {
        if (createConstant) {
            this.isConstant = true;
            this.data = new byte[]{(byte)(0xFF & initValue)};
        } else if (this.length > (long)UnsignedByteLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.type.sizeOf());
            if (initializeMemory) {
                this.initializeNativeMemory(this.length, (byte)(0xFF & initValue));
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.type.sizeOf()));
            MemoryCounter.increaseCounter(this.length * this.type.sizeOf());
        } else {
            this.data = new byte[(int)this.length];
            if (initializeMemory && initValue != 0) {
                Arrays.fill(this.data, (byte)(0xFF & initValue));
            }
        }
    }
}

