/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import sun.misc.Cleaner;

public class ObjectLargeArray
extends LargeArray {
    private static final long serialVersionUID = -4096759496772248522L;
    private Object[] data;
    private ShortLargeArray objectSizes;
    private int maxObjectSize;
    private long size;
    private Class clazz = null;

    public ObjectLargeArray(long length) {
        this(length, 1024);
    }

    public ObjectLargeArray(long length, int maxObjectSize) {
        this(length, maxObjectSize, true);
    }

    public ObjectLargeArray(long length, int maxObjectSize, boolean zeroNativeMemory) {
        this.type = LargeArrayType.OBJECT;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value.");
        }
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException(maxObjectSize + " is not a positive int value.");
        }
        this.length = length;
        this.size = length * (long)maxObjectSize;
        this.maxObjectSize = maxObjectSize;
        this.allocateMemory(zeroNativeMemory, null, false);
    }

    public ObjectLargeArray(long length, int maxObjectSize, Object initValue) {
        this(length, maxObjectSize, initValue, false);
    }

    public ObjectLargeArray(long length, int maxObjectSize, Object initValue, boolean createConstant) {
        this.type = LargeArrayType.OBJECT;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value");
        }
        this.length = length;
        this.size = length * (long)maxObjectSize;
        this.maxObjectSize = maxObjectSize;
        if (initValue != null) {
            this.clazz = initValue.getClass();
        }
        this.allocateMemory(true, initValue, createConstant);
    }

    public ObjectLargeArray(Object[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data array cannot be null");
        }
        if (data.length > 0 && data[0] != null) {
            this.clazz = data[0].getClass();
        }
        for (Object data1 : data) {
            if (data1 == null) {
                throw new IllegalArgumentException("Elements of data array cannot be null");
            }
            if (data1.getClass() == this.clazz) continue;
            throw new IllegalArgumentException("All elements of data array must be of the same type");
        }
        this.type = LargeArrayType.OBJECT;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public ObjectLargeArray clone() {
        if (this.isConstant) {
            return new ObjectLargeArray(this.length, this.maxObjectSize, this.get(0L), true);
        }
        ObjectLargeArray v = new ObjectLargeArray(this.length, FastMath.max((int)1, (int)this.maxObjectSize), false);
        LargeArrayUtils.arraycopy((Object)this, 0L, (Object)v, 0L, this.length);
        v.clazz = this.clazz;
        return v;
    }

    @Override
    public boolean equals(Object o) {
        boolean equal;
        if (o == null || !(o instanceof ObjectLargeArray)) {
            return false;
        }
        ObjectLargeArray la = (ObjectLargeArray)o;
        boolean bl = equal = this.type == la.type && this.length == la.length && this.maxObjectSize == la.maxObjectSize && this.clazz == la.clazz;
        if (!equal) {
            return false;
        }
        if (this.parent != null && la.parent != null ? !this.parent.equals(la.parent) : this.parent != la.parent) {
            return false;
        }
        for (long i = 0L; i < this.length; ++i) {
            Object e2;
            Object e1 = this.get(i);
            if (e1 == (e2 = la.get(i))) continue;
            if (e1 == null) {
                return false;
            }
            if (e1.equals(e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(float quality) {
        int fprint = 29 * super.hashCode(quality);
        fprint = 29 * fprint + (this.maxObjectSize ^ this.maxObjectSize >>> 16);
        fprint = 29 * fprint + (this.clazz != null ? this.clazz.hashCode() : 0);
        if (quality > 0.0f) {
            fprint = 29 * fprint + (this.objectSizes != null ? this.objectSizes.hashCode(quality) : 0);
            long step = (long)FastMath.ceil((double)((float)(1L - this.length) * quality + (float)this.length));
            for (long i = 0L; i < this.length; i += step) {
                Object element = this.get(i);
                fprint = 31 * fprint + (element == null ? 0 : element.hashCode());
            }
        }
        return fprint;
    }

    @Override
    public final Object get(long i) {
        if (this.ptr != 0L) {
            int objLen = this.objectSizes.getShort(i);
            if (objLen <= 0) {
                return null;
            }
            long offset = this.type.sizeOf() * i * (long)this.maxObjectSize;
            byte[] byteArray = new byte[this.maxObjectSize];
            for (int j = 0; j < objLen; ++j) {
                byteArray[j] = LargeArrayUtils.UNSAFE.getByte(this.ptr + offset + this.type.sizeOf() * (long)j);
            }
            return ObjectLargeArray.fromByteArray(byteArray);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public final Object getFromNative(long i) {
        int objLen = this.objectSizes.getShort(i);
        if (objLen < 0) {
            return null;
        }
        long offset = this.type.sizeOf() * i * (long)this.maxObjectSize;
        byte[] byteArray = new byte[this.maxObjectSize];
        for (int j = 0; j < objLen; ++j) {
            byteArray[j] = LargeArrayUtils.UNSAFE.getByte(this.ptr + offset + this.type.sizeOf() * (long)j);
        }
        return ObjectLargeArray.fromByteArray(byteArray);
    }

    @Override
    public final boolean getBoolean(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final byte getByte(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short getUnsignedByte(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short getShort(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final int getInt(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final long getLong(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final float getFloat(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final double getDouble(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public final Object[] getData() {
        return this.data;
    }

    @Override
    public final boolean[] getBooleanData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final byte[] getByteData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short[] getShortData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final short[] getShortData(short[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final int[] getIntData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final int[] getIntData(int[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final long[] getLongData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final long[] getLongData(long[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final float[] getFloatData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final double[] getDoubleData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setToNative(long i, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (this.clazz == null) {
            this.clazz = value.getClass();
        } else if (value.getClass() != this.clazz) {
            throw new IllegalArgumentException("The type of value does not match the type of this ObjectLargeArray");
        }
        byte[] ba = ObjectLargeArray.toByteArray(value);
        if (ba.length > this.maxObjectSize) {
            throw new IllegalArgumentException("Object  " + value + " is too large.");
        }
        int objLen = ba.length;
        if (objLen > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Object  " + value + " is too large.");
        }
        this.objectSizes.setShort(i, (short)objLen);
        long offset = this.type.sizeOf() * i * (long)this.maxObjectSize;
        for (int j = 0; j < objLen; ++j) {
            LargeArrayUtils.UNSAFE.putByte(this.ptr + offset + this.type.sizeOf() * (long)j, ba[j]);
        }
    }

    @Override
    public final void set(long i, Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (this.clazz == null) {
            this.clazz = o.getClass();
        } else if (o.getClass() != this.clazz) {
            throw new IllegalArgumentException("The type of value does not match the type of this ObjectLargeArray");
        }
        if (this.ptr != 0L) {
            byte[] ba = ObjectLargeArray.toByteArray(o);
            if (ba.length > this.maxObjectSize) {
                throw new IllegalArgumentException("Object  " + o + " is too large.");
            }
            int objLen = ba.length;
            if (objLen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Object  " + o + " is too large.");
            }
            this.objectSizes.setShort(i, (short)objLen);
            long offset = this.type.sizeOf() * i * (long)this.maxObjectSize;
            for (int j = 0; j < objLen; ++j) {
                LargeArrayUtils.UNSAFE.putByte(this.ptr + offset + this.type.sizeOf() * (long)j, ba[j]);
            }
        } else if (this.isConstant) {
            this.allocateMemory(true, this.get(0L), false);
            this.isConstant = false;
            this.set(i, o);
        } else {
            this.data[(int)i] = o;
        }
    }

    @Override
    public final void set_safe(long i, Object value) {
        if (i < 0L || i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(i));
        }
        this.set(i, value);
    }

    @Override
    public final void setBoolean(long i, boolean value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setByte(long i, byte value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setUnsignedByte(long i, short value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setShort(long i, short value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setInt(long i, int value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setLong(long i, long value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setFloat(long i, float value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public final void setDouble(long i, double value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private static byte[] toByteArray(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    private static Object fromByteArray(byte[] objectData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        ObjectInputStream ois = null;
        try {
            Object obj;
            ois = new ObjectInputStream(bais);
            Object object = obj = ois.readObject();
            return object;
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public Class getElementClass() {
        return this.clazz;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.data == null) {
            for (long i = 0L; i < this.length; ++i) {
                out.writeObject(this.get(i));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.type != LargeArrayType.OBJECT) {
            throw new IllegalArgumentException("Invalid array type");
        }
        if (this.length <= 0L) {
            throw new IllegalArgumentException("Non-positive array length");
        }
        if (this.data == null) {
            if (this.size <= 0L) {
                throw new IllegalArgumentException("Non-positive size");
            }
            if (this.maxObjectSize <= 0) {
                throw new IllegalArgumentException(this.maxObjectSize + " is not a positive int value.");
            }
            if (this.objectSizes == null || this.objectSizes.length() != this.length) {
                throw new IllegalArgumentException("objectSizes == null || objectSizes.length() != length");
            }
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.size * this.type.sizeOf());
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.type.sizeOf()));
            MemoryCounter.increaseCounter(this.size * this.type.sizeOf());
            for (long i = 0L; i < this.length; ++i) {
                if (this.objectSizes.getShort(i) > 0) {
                    this.set(i, in.readObject());
                    continue;
                }
                in.readObject();
            }
        }
    }

    private void allocateMemory(boolean initializeMemory, Object initValue, boolean createConstant) {
        if (createConstant) {
            this.isConstant = true;
            this.data = new Object[]{initValue};
        } else if (this.length > (long)ObjectLargeArray.getMaxSizeOf32bitArray()) {
            long i;
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.size * this.type.sizeOf());
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.type.sizeOf()));
            MemoryCounter.increaseCounter(this.size * this.type.sizeOf());
            this.objectSizes = new ShortLargeArray(this.length);
            for (i = 0L; i < this.length; ++i) {
                this.objectSizes.setShort(i, (short)-1);
            }
            if (initializeMemory) {
                if (initValue != null) {
                    for (i = 0L; i < this.length; ++i) {
                        this.set(i, initValue);
                    }
                } else {
                    this.initializeNativeMemory(this.size, 0);
                }
            }
        } else {
            this.data = new Object[(int)this.length];
        }
    }
}

