/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayTest;

public class FloatLargeArrayTest
extends LargeArrayTest {
    public FloatLargeArrayTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testEmptyFloatLargeArray() {
        FloatLargeArray a = new FloatLargeArray(0L);
        Assert.assertEquals((long)0L, (long)a.length());
        ArrayIndexOutOfBoundsException e = null;
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        a = new FloatLargeArray(0L, 1.0f, true);
        Assert.assertEquals((long)0L, (long)a.length());
        Assert.assertTrue((boolean)a.isConstant());
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
    }

    @Test
    public void testFloatLargeArrayEqualsHashCode() {
        FloatLargeArray a = new FloatLargeArray(10L);
        FloatLargeArray b = new FloatLargeArray(10L);
        Assert.assertTrue((boolean)a.equals(a));
        Assert.assertTrue((a.hashCode() == a.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == a.hashCode(1.0f) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals(b));
        Assert.assertTrue((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == b.hashCode(1.0f) ? 1 : 0) != 0);
        a.setFloat(0L, 1.0f);
        Assert.assertFalse((boolean)a.equals(b));
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testFloatLargeArrayApproximateHashCode() {
        FloatLargeArray a = new FloatLargeArray(10L);
        FloatLargeArray b = new FloatLargeArray(10L);
        a.setFloat(0L, 1.0f);
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
        a = new FloatLargeArray(10L, 0.0f, true);
        b = new FloatLargeArray(10L, 1.0f, true);
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() {
        Throwable throwable;
        ObjectInputStream in2;
        Throwable throwable2;
        ObjectOutputStream o2;
        Throwable throwable3;
        ByteArrayOutputStream bout;
        long size = 32L;
        FloatLargeArray a = new FloatLargeArray(size);
        FloatLargeArray b = null;
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (FloatLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable in2) {
                    throwable2 = in2;
                    throw in2;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable in2) {
                                throwable2.addSuppressed(in2);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable o2) {
                throwable3 = o2;
                throw o2;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable o2) {
                            throwable3.addSuppressed(o2);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
        a = new FloatLargeArray(size, 2.0f, true);
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (FloatLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
    }

    @Test
    public void testFloatLargeArrayConstant() {
        FloatLargeArray a = new FloatLargeArray(10L, 2.5f, true);
        Assert.assertTrue((boolean)a.isConstant());
        Assert.assertEquals((double)2.5, (double)a.getFloat(0L), (double)1.0E-6);
        Assert.assertEquals((double)2.5, (double)a.getFloat(a.length() - 1L), (double)1.0E-6);
        a.setFloat(0L, 3.5f);
        Assert.assertEquals((double)3.5, (double)a.getFloat(0L), (double)1.0E-6);
        Assert.assertFalse((boolean)a.isConstant());
    }

    @Test
    public void testFloatLargeArrayGetSet() {
        FloatLargeArray a = new FloatLargeArray(10L);
        long idx = 5L;
        float val = 3.4f;
        a.setFloat(idx, val);
        Assert.assertEquals((double)val, (double)a.getFloat(idx), (double)1.0E-6);
        idx = 6L;
        a.set(idx, Float.valueOf(val));
        Assert.assertEquals((double)val, (double)a.get(idx).floatValue(), (double)1.0E-6);
    }

    @Test
    public void testFloatLargeArrayGetSetNative() {
        FloatLargeArray a = new FloatLargeArray(10L);
        if (a.isLarge()) {
            long idx = 5L;
            float val = 3.4f;
            a.setToNative(idx, Float.valueOf(val));
            Assert.assertEquals((double)val, (double)a.getFromNative(idx).floatValue(), (double)1.0E-6);
        }
    }

    @Test
    public void testFloatLargeArrayGetData() {
        float[] data = new float[]{1.1f, 2.2f, 3.3f, 4.4f, 5.5f, 6.6f, 7.7f, 8.8f, 9.9f, 10.1f};
        long startPos = 2L;
        long endPos = 7L;
        long step = 2L;
        LargeArray.setMaxSizeOf32bitArray(0x40000000);
        FloatLargeArray a = new FloatLargeArray(data);
        float[] res = a.getFloatData(null, startPos, endPos, step);
        int idx = 0;
        for (long i = startPos; i < endPos; i += step) {
            Assert.assertEquals((double)data[(int)i], (double)res[idx++], (double)1.0E-6);
        }
    }
}

