/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;

public class ComplexFloatLargeArray
extends LargeArray {
    private static final long serialVersionUID = 7475425228321409910L;
    private FloatLargeArray dataRe;
    private FloatLargeArray dataIm;

    public ComplexFloatLargeArray(long length) {
        this(length, true);
    }

    public ComplexFloatLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.COMPLEX_FLOAT;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value");
        }
        this.length = length;
        this.dataRe = new FloatLargeArray(length, zeroNativeMemory);
        this.dataIm = new FloatLargeArray(length, zeroNativeMemory);
    }

    public ComplexFloatLargeArray(long length, float[] initValue) {
        this(length, initValue, false);
    }

    public ComplexFloatLargeArray(long length, float[] initValue, boolean createConstant) {
        this.type = LargeArrayType.COMPLEX_FLOAT;
        if (length < 0L) {
            throw new IllegalArgumentException(length + " is not a nonnegative long value");
        }
        if (initValue == null || initValue.length != 2) {
            throw new IllegalArgumentException("initValue == null || initValue.length != 2");
        }
        this.length = length;
        this.isConstant = createConstant;
        this.dataRe = new FloatLargeArray(length, initValue[0], createConstant);
        this.dataIm = new FloatLargeArray(length, initValue[1], createConstant);
    }

    public ComplexFloatLargeArray(float[] data) {
        this(new FloatLargeArray(data));
    }

    public ComplexFloatLargeArray(FloatLargeArray data) {
        if (data.length() % 2L != 0L) {
            throw new IllegalArgumentException("The length of the data array must be even.");
        }
        if (data.length() < 0L) {
            throw new IllegalArgumentException(data.length() + " is not a nonnegative long value");
        }
        this.type = LargeArrayType.COMPLEX_FLOAT;
        this.length = data.length / 2L;
        this.isConstant = data.isConstant;
        if (this.isConstant) {
            this.dataRe = new FloatLargeArray(this.length, data.getFloat(0L), true);
            this.dataIm = new FloatLargeArray(this.length, data.getFloat(1L), true);
        } else {
            this.dataRe = new FloatLargeArray(this.length, false);
            this.dataIm = new FloatLargeArray(this.length, false);
            for (long i = 0L; i < this.length; ++i) {
                this.dataRe.setFloat(i, data.getFloat(2L * i));
                this.dataIm.setFloat(i, data.getFloat(2L * i + 1L));
            }
        }
    }

    public ComplexFloatLargeArray(float[] dataRe, float[] dataIm) {
        this(new FloatLargeArray(dataRe), new FloatLargeArray(dataIm));
    }

    public ComplexFloatLargeArray(FloatLargeArray dataRe, FloatLargeArray dataIm) {
        if (dataRe.length() != dataIm.length()) {
            throw new IllegalArgumentException("The length of the dataRe must be equal to the length of dataIm.");
        }
        if (dataRe.length() < 0L) {
            throw new IllegalArgumentException(dataRe.length() + " is not a nonnegative long value");
        }
        this.type = LargeArrayType.COMPLEX_FLOAT;
        this.length = dataRe.length();
        this.dataRe = dataRe;
        this.dataIm = dataIm;
    }

    @Override
    public ComplexFloatLargeArray clone() {
        return (ComplexFloatLargeArray)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        boolean equal;
        if (o == null || !(o instanceof ComplexFloatLargeArray)) {
            return false;
        }
        ComplexFloatLargeArray la = (ComplexFloatLargeArray)o;
        boolean bl = equal = this.type == la.type && this.length == la.length;
        if (!equal) {
            return false;
        }
        if (this.parent != null && la.parent != null ? !this.parent.equals(la.parent) : this.parent != la.parent) {
            return false;
        }
        for (long i = 0L; i < this.length; ++i) {
            float[] elem2;
            float[] elem1 = this.get(i);
            if (Float.compare(elem1[0], (elem2 = la.get(i))[0]) != 0) {
                return false;
            }
            if (Float.compare(elem1[1], elem2[1]) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(float quality) {
        int fprint = 29 * super.hashCode(quality);
        if (quality > 0.0f) {
            long step = (long)FastMath.ceil((double)((float)(1L - this.length) * quality + (float)this.length));
            for (long i = 0L; i < this.length; i += step) {
                float[] element = this.get(i);
                fprint = 31 * fprint + Float.floatToIntBits(element[0]) + Float.floatToIntBits(element[1]);
            }
        }
        return fprint;
    }

    @Override
    public boolean isLarge() {
        return this.dataRe.isLarge() || this.dataIm.isLarge();
    }

    @Override
    public boolean isConstant() {
        return this.dataRe.isConstant() && this.dataIm.isConstant();
    }

    public final FloatLargeArray getRealArray() {
        return this.dataRe;
    }

    public final FloatLargeArray getImaginaryArray() {
        return this.dataIm;
    }

    public final FloatLargeArray getAbsArray() {
        FloatLargeArray out = new FloatLargeArray(this.length, false);
        for (long i = 0L; i < this.length; ++i) {
            double re = this.dataRe.getFloat(i);
            double im = this.dataIm.getFloat(i);
            out.setFloat(i, (float)FastMath.sqrt((double)(re * re + im * im)));
        }
        return out;
    }

    public final FloatLargeArray getArgArray() {
        FloatLargeArray out = new FloatLargeArray(this.length, false);
        for (long i = 0L; i < this.length; ++i) {
            double re = this.dataRe.getFloat(i);
            double im = this.dataIm.getFloat(i);
            out.setFloat(i, (float)FastMath.atan2((double)im, (double)re));
        }
        return out;
    }

    public final float[] get(long i) {
        return this.getComplexFloat(i);
    }

    public final float[] getFromNative(long i) {
        return new float[]{this.dataRe.getFromNative(i).floatValue(), this.dataIm.getFromNative(i).floatValue()};
    }

    @Override
    public final boolean getBoolean(long i) {
        return this.dataRe.getBoolean(i);
    }

    @Override
    public final byte getByte(long i) {
        return this.dataRe.getByte(i);
    }

    @Override
    public final short getUnsignedByte(long i) {
        return this.dataRe.getUnsignedByte(i);
    }

    @Override
    public final short getShort(long i) {
        return this.dataRe.getShort(i);
    }

    @Override
    public final int getInt(long i) {
        return this.dataRe.getInt(i);
    }

    @Override
    public final long getLong(long i) {
        return this.dataRe.getLong(i);
    }

    @Override
    public final float getFloat(long i) {
        return this.dataRe.getFloat(i);
    }

    @Override
    public final double getDouble(long i) {
        return this.dataRe.getDouble(i);
    }

    public final float[] getComplexFloat(long i) {
        return new float[]{this.dataRe.getFloat(i), this.dataIm.getFloat(i)};
    }

    public final double[] getComplexDouble(long i) {
        return new double[]{this.dataRe.getDouble(i), this.dataIm.getDouble(i)};
    }

    public final float[][] getData() {
        if (this.isLarge()) {
            return null;
        }
        return new float[][]{this.dataRe.getData(), this.dataIm.getData()};
    }

    @Override
    public final boolean[] getBooleanData() {
        return this.dataRe.getBooleanData();
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        return this.dataRe.getBooleanData(a, startPos, endPos, step);
    }

    @Override
    public final byte[] getByteData() {
        return this.dataRe.getByteData();
    }

    @Override
    public final byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        return this.dataRe.getByteData(a, startPos, endPos, step);
    }

    @Override
    public final short[] getShortData() {
        return this.dataRe.getShortData();
    }

    @Override
    public final short[] getShortData(short[] a, long startPos, long endPos, long step) {
        return this.dataRe.getShortData(a, startPos, endPos, step);
    }

    @Override
    public final int[] getIntData() {
        return this.dataRe.getIntData();
    }

    @Override
    public final int[] getIntData(int[] a, long startPos, long endPos, long step) {
        return this.dataRe.getIntData(a, startPos, endPos, step);
    }

    @Override
    public final long[] getLongData() {
        return this.dataRe.getLongData();
    }

    @Override
    public final long[] getLongData(long[] a, long startPos, long endPos, long step) {
        return this.dataRe.getLongData(a, startPos, endPos, step);
    }

    @Override
    public final float[] getFloatData() {
        return this.dataRe.getFloatData();
    }

    @Override
    public final float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        return this.dataRe.getFloatData(a, startPos, endPos, step);
    }

    @Override
    public final double[] getDoubleData() {
        return this.dataRe.getDoubleData();
    }

    @Override
    public final double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        return this.dataRe.getDoubleData(a, startPos, endPos, step);
    }

    public final float[] getComplexData() {
        if (2L * this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)(2L * this.length)];
        int i = 0;
        while ((long)i < this.length) {
            out[2 * i] = this.dataRe.getFloat(i);
            out[2 * i + 1] = this.dataIm.getFloat(i);
            ++i;
        }
        return out;
    }

    public final float[] getComplexData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = 2L * (long)FastMath.ceil((double)((double)(endPos - startPos) / (double)step));
        if (len > 0x40000000L) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        for (long i = startPos; i < endPos; i += step) {
            out[idx++] = this.dataRe.getFloat(i);
            out[idx++] = this.dataIm.getFloat(i);
        }
        return out;
    }

    @Override
    public final void setToNative(long i, Object value) {
        if (!(value instanceof float[])) {
            throw new IllegalArgumentException(value + " is not an array of floats.");
        }
        this.dataRe.setToNative(i, Float.valueOf(((float[])value)[0]));
        this.dataIm.setToNative(i, Float.valueOf(((float[])value)[1]));
    }

    @Override
    public final void setBoolean(long i, boolean value) {
        this.dataRe.setBoolean(i, value);
        this.dataIm.setBoolean(i, false);
    }

    @Override
    public final void setByte(long i, byte value) {
        this.dataRe.setByte(i, value);
        this.dataIm.setByte(i, (byte)0);
    }

    @Override
    public final void setUnsignedByte(long i, short value) {
        this.dataRe.setUnsignedByte(i, value);
        this.dataIm.setUnsignedByte(i, (short)0);
    }

    @Override
    public final void setShort(long i, short value) {
        this.dataRe.setShort(i, value);
        this.dataIm.setShort(i, (short)0);
    }

    @Override
    public final void setInt(long i, int value) {
        this.dataRe.setInt(i, value);
        this.dataIm.setInt(i, 0);
    }

    @Override
    public final void setLong(long i, long value) {
        this.dataRe.setLong(i, value);
        this.dataIm.setLong(i, 0L);
    }

    @Override
    public final void setFloat(long i, float value) {
        this.dataRe.setFloat(i, value);
        this.dataIm.setFloat(i, 0.0f);
    }

    @Override
    public final void setDouble(long i, double value) {
        this.dataRe.setDouble(i, value);
        this.dataIm.setDouble(i, 0.0);
    }

    @Override
    public final void set(long i, Object value) {
        if (!(value instanceof float[])) {
            throw new IllegalArgumentException(value + " is not an array of floats.");
        }
        this.setComplexFloat(i, (float[])value);
    }

    public final void setComplexFloat(long i, float[] value) {
        this.dataRe.setFloat(i, value[0]);
        this.dataIm.setFloat(i, value[1]);
    }

    public final void setComplexDouble(long i, double[] value) {
        this.dataRe.setDouble(i, value[0]);
        this.dataIm.setDouble(i, value[1]);
    }
}

