/*
 * Decompiled with CFR 0.152.
 */
package cambria.stat;

public class TimeSeriesAnalysis {
    public static boolean checkIfTransient(float[] timeSeries, int currentTime, int window, int reverseCount) {
        if (currentTime - window < 0) {
            throw new IllegalArgumentException("window is too large.");
        }
        boolean isTransient = true;
        int reverse = 0;
        int i = 0;
        do {
            if (timeSeries[currentTime - i] >= timeSeries[currentTime - i - 1]) {
                ++reverse;
            }
            if (reverse != reverseCount) continue;
            isTransient = false;
        } while (++i < window);
        return isTransient;
    }

    public static boolean checkIfTransient(float[] timeSeries, int currentTime, int window, float eps) {
        if (currentTime - window < 0) {
            throw new IllegalArgumentException("window is too large.");
        }
        boolean isTransient = false;
        int i = 0;
        do {
            float delta;
            if (!((delta = Math.abs(timeSeries[currentTime - i] - timeSeries[currentTime - i - 1])) > eps)) continue;
            isTransient = true;
        } while (!isTransient && ++i < window);
        return isTransient;
    }
}

