/*
 * Decompiled with CFR 0.152.
 */
package cambria.mmi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;

public class Plotter
extends JPanel {
    private static final long serialVersionUID = 1L;
    public float[] xa;
    public float[][] ya;
    int maxData;
    int maxArray;
    Container con;
    String title;
    Color[] lineColor = new Color[]{Color.red, Color.black, Color.pink, Color.blue, Color.yellow, Color.green, Color.cyan, Color.white};
    Color axisColor = Color.cyan;
    Color backColor = Color.gray;
    int leftMargin;
    int rightMargin;
    int bottomMargin;
    int topMargin;
    float x_scale;
    float y_scale;
    float x_min;
    float y_min;
    float x_max;
    float y_max;
    int w;
    int h;
    Dimension size;
    Font myFont = new Font("time", 1, 11);
    FontMetrics myFontMetrics;
    static final int x_margin = 50;
    static final int y_margin = 80;
    String graphType;
    int x_gcnt = 5;
    int y_gcnt = 5;
    int x_decimal;
    int y_decimal;

    public Plotter() {
    }

    public Plotter(String title, Container con) {
        this.ya = new float[8][16384];
        this.con = con;
        this.title = title;
        this.w = con.getSize().width - 50;
        this.h = con.getSize().height - 80;
        this.size = new Dimension(this.w, this.h);
        this.setLayout(new BorderLayout());
        this.setBackground(this.backColor);
    }

    @Override
    public void paint(Graphics g) {
        g.setFont(this.myFont);
        if (this.title != "") {
            g.setColor(this.axisColor);
            g.drawString(this.title, Math.max((this.w - this.myFontMetrics.stringWidth(this.title)) / 2, 0), this.myFontMetrics.getAscent());
        }
        if (this.maxData == 0 || this.maxArray == 0) {
            return;
        }
        if (!this.verify(this.maxData, this.maxArray)) {
            System.out.println(" ERROR: Y-Data size out of range. ");
        }
        if (this.xa == null) {
            this.xa = new float[this.maxData];
            for (int i = 0; i < this.maxData; ++i) {
                this.xa[i] = i;
            }
        } else {
            int len = this.xa.length;
            if (len != this.maxData) {
                System.out.println(" ERROR: X-Data size does not match. ");
            }
        }
        if (this.x_max == this.x_min) {
            this.x_max = this.f_maximum(this.xa);
            this.x_min = this.f_minimum(this.xa);
            this.y_max = this.f_maximum();
            this.y_min = this.f_minimum();
        }
        this.x_scale = (float)this.w * 0.8f / (this.x_max - this.x_min);
        this.leftMargin = (int)Math.round((double)this.w * 0.15);
        this.rightMargin = (int)Math.round((double)this.w * 0.05);
        this.y_scale = (float)this.h * 0.8f / (this.y_max - this.y_min);
        this.topMargin = (int)Math.round((double)this.h * 0.1);
        this.bottomMargin = (int)Math.round((double)this.h * 0.1);
        this.xLegend(g, this.x_gcnt, this.x_decimal);
        this.yLegend(g, this.y_gcnt, this.y_decimal);
        if (this.graphType.regionMatches(true, 0, "line", 0, 4)) {
            this.lineGraph(g);
        } else if (this.graphType.regionMatches(true, 0, "circle", 0, 6)) {
            this.circleGraph(g);
        } else {
            this.lineGraph(g);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXData(float[] xa) {
        this.xa = xa;
    }

    public void setYData(float[][] yaIn) {
        this.maxArray = yaIn.length;
        this.maxData = yaIn[0].length;
        for (int i = 0; i < this.maxArray; ++i) {
            for (int j = 0; j < this.maxData; ++j) {
                this.ya[i][j] = yaIn[i][j];
            }
        }
    }

    public void setYData(float[] yaIn) {
        this.maxArray = 1;
        for (float this.ya[0][j] : yaIn) {
        }
    }

    public void appendYData(float[] yaIn) {
        if (this.maxData != yaIn.length) {
            System.out.println("Plotter: Y-data length violation");
            return;
        }
        ++this.maxArray;
        for (int j = 0; j < this.maxData; ++j) {
            this.ya[this.maxArray - 1][j] = yaIn[j];
        }
    }

    public void appendYData(float[][] yaIn) {
        if (this.maxData != yaIn.length) {
            System.out.println("Plotter: Y-data length violation");
            return;
        }
        int maxInArray = yaIn[0].length;
        this.maxArray += maxInArray;
        for (int i = 0; i < maxInArray; ++i) {
            for (int j = 0; j < this.maxData; ++j) {
                this.ya[this.maxArray - maxInArray + i][j] = yaIn[i][j];
            }
        }
    }

    public void setDecimal(int x_decimal, int y_decimal) {
        this.x_decimal = x_decimal;
        this.y_decimal = y_decimal;
    }

    public void setMarkerNumber(int x_gcnt, int y_gcnt) {
        this.x_gcnt = x_gcnt;
        this.y_gcnt = y_gcnt;
    }

    public void setGraphType(String graphType) {
        this.graphType = graphType;
    }

    boolean verify(int maxData, int maxArray) {
        if (maxData > 4096 || maxData < 0) {
            return false;
        }
        return maxArray <= 256 && maxArray >= 1;
    }

    public void setColor(int array, Color color) {
        this.lineColor[array] = color;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public void setFont(String fontType, int fontSize) {
        this.myFont = new Font(fontType, 1, fontSize);
        this.myFontMetrics = this.getFontMetrics(this.myFont);
    }

    public void setRange(double x_min, double y_min, double x_max, double y_max) {
        this.x_min = (float)x_min;
        this.y_min = (float)y_min;
        this.x_max = (float)x_max;
        this.y_max = (float)y_max;
    }

    public void setXRange(double x_min, double x_max) {
        this.x_min = (float)x_min;
        this.x_max = (float)x_max;
    }

    public void setYRange(double y_min, double y_max) {
        this.y_min = (float)y_min;
        this.y_max = (float)y_max;
    }

    public void resetRange() {
        this.x_min = 0.0f;
        this.y_min = 0.0f;
        this.x_max = 0.0f;
        this.y_max = 0.0f;
    }

    float f_maximum(float xx, int exponent) {
        return (float)Math.ceil(xx / (float)exponent) * (float)exponent;
    }

    float f_maximum(float[] xx) {
        float f_max = -3.4028235E38f;
        for (int i = 0; i < xx.length; ++i) {
            f_max = Math.max(xx[i], f_max);
        }
        return (float)Math.ceil((double)f_max / 100.0) * 100.0f;
    }

    float f_maximum() {
        float[] xx0 = new float[this.maxData];
        float[] xx0_max = new float[this.maxArray];
        for (int j = 0; j < this.maxArray; ++j) {
            for (int i = 0; i < this.maxData; ++i) {
                xx0[i] = this.ya[j][i];
            }
            xx0_max[j] = this.f_maximum(xx0);
        }
        return this.f_maximum(xx0_max);
    }

    float f_minimum(float xx, int exponent) {
        return (float)Math.floor(xx / (float)exponent) * (float)exponent;
    }

    float f_minimum(float[] xx) {
        float f_min = Float.MAX_VALUE;
        for (int i = 0; i < xx.length; ++i) {
            f_min = Math.min(xx[i], f_min);
        }
        return (float)Math.floor((double)f_min / 100.0) * 100.0f;
    }

    float f_minimum() {
        float[] xx0 = new float[this.maxData];
        float[] xx0_min = new float[this.maxArray];
        for (int j = 0; j < this.maxArray; ++j) {
            for (int i = 0; i < this.maxData; ++i) {
                xx0[i] = this.ya[j][i];
            }
            xx0_min[j] = this.f_minimum(xx0);
        }
        return this.f_minimum(xx0_min);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    void xLegend(Graphics g, int gcnt, int decimal) {
        float markValue = 0.0f;
        float divWidth = (this.x_max - this.x_min) / (float)gcnt;
        double tempValue = Math.pow(10.0, decimal);
        for (int i = 0; i < gcnt + 1; ++i) {
            markValue = (float)((double)Math.round((double)(this.x_min + divWidth * (float)i) * tempValue) / tempValue);
            int markPoint = (int)(this.x_scale * divWidth * (float)i + (float)this.leftMargin);
            String markString = decimal > 0 ? Float.toString(markValue) : Integer.toString((int)markValue);
            int len = markString.length();
            g.drawString(markString, markPoint - this.myFont.getSize() * (len / 2), this.h - this.myFontMetrics.getDescent() * 2);
            g.drawLine(markPoint, this.topMargin + 1, markPoint, this.h - this.bottomMargin - 1);
        }
    }

    void yLegend(Graphics g, int gcnt, int decimal) {
        float divWidth = (this.y_max - this.y_min) / (float)gcnt;
        double tempValue = Math.pow(10.0, decimal);
        float markValue = 0.0f;
        for (int i = 0; i < gcnt + 1; ++i) {
            markValue = (float)((double)Math.round((double)(this.y_min + divWidth * (float)i) * tempValue) / tempValue);
            int markPoint = this.h - (int)(this.y_scale * divWidth * (float)i) - this.bottomMargin;
            if (decimal > 0) {
                g.drawString(Float.toString(markValue), 0, markPoint);
            } else {
                g.drawString(Integer.toString((int)markValue), 0, markPoint);
            }
            g.drawLine(this.leftMargin + 1, markPoint, this.w - this.rightMargin - 1, markPoint);
        }
    }

    void lineGraph(Graphics g) {
        int xi_prev = 0;
        int yi_prev = 0;
        for (int j = 0; j < this.maxArray; ++j) {
            g.setColor(this.lineColor[j]);
            for (int i = 0; i < this.maxData; ++i) {
                int xi = (int)Math.floor(this.x_scale * (this.xa[i] - this.x_min)) + this.leftMargin;
                int yi = this.h - (int)Math.floor(this.y_scale * (this.ya[j][i] - this.y_min)) - this.bottomMargin;
                if (i > 0) {
                    g.drawLine(xi_prev, yi_prev, xi, yi);
                }
                xi_prev = xi;
                yi_prev = yi;
            }
        }
    }

    void circleGraph(Graphics g) {
        for (int j = 0; j < this.maxArray; ++j) {
            g.setColor(this.lineColor[j]);
            for (int i = 0; i < this.maxData; ++i) {
                int xi = (int)Math.floor(this.x_scale * (this.xa[i] - this.x_min)) + this.leftMargin;
                int yi = this.h - (int)Math.floor(this.y_scale * (this.ya[j][i] - this.y_min)) - this.bottomMargin;
                g.fillOval(xi - 1, yi - 1, 3, 3);
            }
        }
    }
}

