/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.VNRule;
import java.awt.Button;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RuleAnalyzer
extends Frame
implements ActionListener {
    TextArea ta = new TextArea(20, 40);
    int maxStatePerCell = 256;
    int statePerCell;
    boolean[][] origin;
    boolean[][] expansivity;
    float lambda;
    float mu;
    protected Panel mainPanel;
    protected Panel subPanel;
    VNRule rule;

    public RuleAnalyzer(VNRule rule) {
        int i;
        int j;
        this.rule = rule;
        this.statePerCell = rule.getStatePerCell();
        this.origin = new boolean[this.statePerCell][this.statePerCell];
        this.getOrigin();
        for (j = 0; j < this.statePerCell; ++j) {
            this.ta.append(j + "'s seed : ");
            for (i = 0; i < this.statePerCell; ++i) {
                if (!this.origin[i][j]) continue;
                this.ta.append(i + " ");
            }
            this.ta.append(System.getProperty("line.separator"));
        }
        this.expansivity = new boolean[this.statePerCell][this.statePerCell];
        this.getExpansivity();
        for (j = 0; j < this.statePerCell; ++j) {
            this.ta.append("State" + j + " expands into : ");
            for (i = 0; i < this.statePerCell; ++i) {
                if (!this.expansivity[j][i]) continue;
                this.ta.append(i + " ");
            }
            this.ta.append(System.getProperty("line.separator"));
        }
        this.lambda = this.getLambda();
        this.ta.append(System.getProperty("line.separator"));
        this.ta.append("Lambda-parameter : " + this.lambda);
        this.ta.append(System.getProperty("line.separator"));
        this.mu = this.getMu();
        this.ta.append(System.getProperty("line.separator"));
        this.ta.append("Mu-parameter : " + this.mu);
        this.ta.append(System.getProperty("line.separator"));
        this.add("Center", this.ta);
        this.subPanel = new Panel();
        Button closeButton = new Button("close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        this.subPanel.add(closeButton);
        this.add("South", this.subPanel);
        this.pack();
    }

    public void getOrigin() {
        for (int i = 0; i < this.statePerCell; ++i) {
            for (int j = 0; j < this.statePerCell; ++j) {
                this.origin[i][j] = true;
            }
        }
        for (int h = 0; h < this.statePerCell; ++h) {
            for (int n = 0; n < this.statePerCell; ++n) {
                for (int e = 0; e < this.statePerCell; ++e) {
                    for (int s = 0; s < this.statePerCell; ++s) {
                        for (int w = 0; w < this.statePerCell; ++w) {
                            int out = this.rule.output((byte)h, (byte)n, (byte)e, (byte)s, (byte)w);
                            for (int i = 0; i < this.statePerCell; ++i) {
                                for (int j = 0; j < this.statePerCell; ++j) {
                                    if (!(j == out & h != i & n != i & e != i & s != i & w != i)) continue;
                                    this.origin[i][j] = false;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void getExpansivity() {
        for (int fore = 0; fore < this.statePerCell; ++fore) {
            for (int back = 0; back < this.statePerCell; ++back) {
                this.expansivity[fore][back] = this.checkExpansivity(fore, back);
            }
        }
    }

    public boolean checkExpansivity(int fore, int back) {
        if (this.rule.output((byte)back, (byte)fore, (byte)back, (byte)back, (byte)back) != (byte)fore) {
            return false;
        }
        if (this.rule.output((byte)back, (byte)back, (byte)fore, (byte)back, (byte)back) != (byte)fore) {
            return false;
        }
        if (this.rule.output((byte)back, (byte)back, (byte)back, (byte)fore, (byte)back) != (byte)fore) {
            return false;
        }
        return this.rule.output((byte)back, (byte)back, (byte)back, (byte)back, (byte)fore) == (byte)fore;
    }

    public float getLambda() {
        int sum = 0;
        for (int i = 0; i < this.rule.maxRuleEntry; ++i) {
            if (this.rule.ruleArray[i] <= 0) continue;
            ++sum;
        }
        return (float)sum / (float)this.rule.maxRuleEntry;
    }

    public float getMu() {
        int sum = 0;
        for (int h = 0; h < this.statePerCell; ++h) {
            for (int n = 0; n < this.statePerCell; ++n) {
                for (int e = 0; e < this.statePerCell; ++e) {
                    for (int s = 0; s < this.statePerCell; ++s) {
                        for (int w = 0; w < this.statePerCell; ++w) {
                            int out = this.rule.output((byte)h, (byte)n, (byte)e, (byte)s, (byte)w);
                            if (out == h) continue;
                            ++sum;
                        }
                    }
                }
            }
        }
        return (float)sum / (float)this.rule.maxRuleEntry;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("close")) {
            this.setVisible(false);
        }
    }
}

