/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.VonNeumann;
import cambria.misc.MyMath;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Random;

public class PottsVNRule
extends CARule
implements AdjustmentListener {
    private static final int interact = 1;
    private static final int statePerCell = 4;
    private static final int maxNeighbor = 5;
    private Random rand = new Random(System.currentTimeMillis());
    private Panel mainPanel;
    private Panel subPanel;
    private Scrollbar betaSlider;
    private TextField textField;
    private Button closeButton;
    private double coldestBeta = 2.0;
    private double hottestBeta = 0.2;
    private double beta = 0.5;

    private int getDeltaEnergy(VonNeumann neighbor, int nextState) {
        int total = 0;
        int nextTotal = 0;
        byte[] neighborState = neighbor.getNeighborState();
        for (int i = 1; i < neighbor.getMaxNeighbor(); ++i) {
            if (neighborState[0] != neighborState[i]) {
                ++total;
            }
            if (nextState == neighborState[i]) continue;
            ++nextTotal;
        }
        return nextTotal - total;
    }

    @Override
    public String getDefaultThread() {
        return "MCSThread";
    }

    @Override
    public int output(BlockOfCells boc) {
        double prob;
        VonNeumann neighbor = (VonNeumann)boc;
        int nextState = MyMath.irand(4);
        int deltaEnergy = this.getDeltaEnergy(neighbor, nextState);
        if (deltaEnergy < 0) {
            return nextState;
        }
        double rnd = this.rand.nextDouble();
        return rnd < (prob = Math.exp(-this.beta * (double)deltaEnergy)) ? nextState : (int)neighbor.getHomeState();
    }

    @Override
    public int getStatePerCell() {
        return 4;
    }

    @Override
    public int getMaxNeighbor() {
        return 5;
    }

    @Override
    public void edit() {
        if (this.subPanel == null) {
            this.addMainPanel();
            this.subPanel = new Panel();
            this.closeButton = new Button("close");
            this.closeButton.addActionListener(this);
            this.subPanel.add(this.closeButton);
            this.add("South", this.subPanel);
            this.pack();
        }
        this.setVisible(true);
    }

    private void addMainPanel() {
        this.mainPanel = new Panel();
        int maxUnit = (int)((this.coldestBeta - this.hottestBeta) * 1000.0);
        this.betaSlider = new Scrollbar(0, (int)(-(this.beta - this.coldestBeta) * 1000.0), 10, 0, maxUnit);
        this.betaSlider.addAdjustmentListener(this);
        this.textField = new TextField(Float.toString((float)this.beta), 10);
        this.textField.setEditable(false);
        this.mainPanel.setLayout(new GridLayout(0, 1));
        this.mainPanel.add(this.betaSlider);
        this.mainPanel.add(this.textField);
        this.add("Center", this.mainPanel);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.beta = this.coldestBeta - (double)e.getValue() / 1000.0;
        this.textField.setText(String.valueOf((float)this.beta));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.setVisible(false);
        } else {
            System.out.println("IsingRule: Unknown button clicked");
        }
    }
}

