/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CAPhenotype;
import cambria.CARule;
import cambria.CASearch;
import cambria.EvolvingBlockVNRule;
import cambria.jgat.GeneticAlgorithm;
import cambria.jgat.Genotype;
import cambria.jgat.Phenotype;
import cambria.misc.MyFileWriter;
import cambria.misc.MyString;

public class ParallelSampling {
    public static void main(String[] args) {
        try {
            System.out.println("% initial run is " + args[0]);
            System.out.println("% final run is " + args[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: >java ParallelSampling <initial run> <final run>");
            System.exit(-1);
        }
        int initialRun = MyString.convertIntParameter(args[0]);
        int finalRun = MyString.convertIntParameter(args[0]);
        int maxRun = MyString.convertIntParameter(args[0]);
        CARule rule = CARule.createRule("EvolvingBlockVNRule");
        String RuleString = "2 5 r:c01010:c01001";
        String RuleFile = null;
        rule.setRule(RuleString, RuleFile);
        ((Genotype)((Object)rule)).randomizeChromosome();
        boolean torus = true;
        String InitType = "random";
        boolean synchronous = false;
        int x_max = 100;
        int y_max = 100;
        CAPhenotype checkerCA = new CAPhenotype(rule, torus, InitType, synchronous, x_max, y_max);
        int populationSize = 20;
        int eliteSize = 6;
        double mutationRate = 0.05;
        double crossoverRate = 0.5;
        int maxIter = 300;
        double goalOfFitness = 0.64;
        StringBuffer buff = new StringBuffer();
        CASearch.dataLog("% Population size is " + populationSize, buff);
        CASearch.dataLog("% Elite size is " + eliteSize, buff);
        CASearch.dataLog("% Goal of fitness is " + goalOfFitness, buff);
        CASearch.dataLog("% Mutation rate is " + mutationRate, buff);
        CASearch.dataLog("% Crossover rate is " + crossoverRate, buff);
        CASearch.dataLog("% Initial concentration is " + checkerCA.getConcentration(), buff);
        CASearch.dataLog("% Cell Space Size is " + checkerCA.getXMax() + " x " + checkerCA.getYMax(), buff);
        Genotype[] rules = new EvolvingBlockVNRule[populationSize];
        Phenotype[] phenotype = new Phenotype[populationSize];
        for (int i = 0; i < populationSize; ++i) {
            rules[i] = (Genotype)((Object)CARule.createRule("EvolvingBlockVNRule"));
            ((CARule)((Object)rules[i])).setRule(((EvolvingBlockVNRule)rule).getRuleString(), null);
            rules[i].randomizeChromosome();
            phenotype[i] = new CAPhenotype((CARule)((Object)rules[i]), checkerCA.isTorus(), checkerCA.getInitType(), checkerCA.isSynchronous(), checkerCA.getXMax(), checkerCA.getYMax());
            phenotype[i].setGoalOfFitness(goalOfFitness);
        }
        GeneticAlgorithm ga = new GeneticAlgorithm(rules, phenotype, eliteSize);
        ga.setMutationRate(mutationRate);
        ga.setCrossoverRate(crossoverRate);
        String fileStemName = "check";
        int i = initialRun - 1;
        while (i < finalRun) {
            if (ga.isOptimized()) {
                throw new RuntimeException("Already Optimized");
            }
            ga.step();
            ga.report(buff);
            if (!CASearch.isThereOptimizedPhenotype(phenotype)) continue;
            CASearch.dataLog("    Optimized : " + ++i, buff);
            int bestIndividual = GeneticAlgorithm.getBestFitNumber(phenotype, populationSize);
            CASearch.dataLog("     " + bestIndividual + " : " + phenotype[bestIndividual].getFitness(), buff);
            StringBuffer str = new StringBuffer().append(fileStemName).append(MyString.getDigits(i, 3));
            String filename = str.toString();
            CASearch.dataLog("     The chromosome best fit is " + bestIndividual + System.getProperty("line.separator"), buff);
            ((EvolvingBlockVNRule)rules[bestIndividual]).saveRuleFile(filename + ".par");
            for (int j = 0; j < populationSize; ++j) {
                rules[j].randomizeChromosome();
            }
            ga.setOptimized(false);
        }
        MyFileWriter.saveString("ParallelSampling.log", buff.toString());
    }
}

