/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.Block16;
import cambria.Block4Rule;
import cambria.Block9;
import cambria.Block9Rule;
import cambria.BlockOfCells;
import cambria.BlockVN;
import cambria.BlockVNRule;
import cambria.BrainRule;
import cambria.CABatch;
import cambria.CAConfigBase;
import cambria.CARule;
import cambria.CanonicalRule;
import cambria.CheckRule;
import cambria.Dosable;
import cambria.EntroS;
import cambria.GMBrainRule;
import cambria.GenerationRule;
import cambria.HodgeRule;
import cambria.InteractingEnergy;
import cambria.Life2Rule;
import cambria.LifeRule;
import cambria.Margolus;
import cambria.Moore;
import cambria.Partition;
import cambria.PartitionIF;
import cambria.StarWarsRule;
import cambria.TransersRule;
import cambria.VonNeumann;
import cambria.jgat.FitnessLandscape;
import cambria.misc.MyFileReader;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.util.Random;

public class CAConfig
extends CAConfigBase
implements FitnessLandscape {
    private boolean synchronous = true;
    private boolean torus = true;
    private int statePerCell;
    private static final int maxStatePerCell = 256;
    private byte[][] caState;
    private byte[][] prevState;
    private int x_max;
    private int y_max;
    private int initNo;
    private static final String[] InitTypeArray = new String[]{"random  ", "letter_j", "empty   ", "single  ", "square  ", "cross   ", "e_rand  ", "srloop  ", "checker ", "ground  "};
    private String InitType;
    private BlockOfCells partitionIn;
    private BlockOfCells partitionOut;
    private BlockOfCells neighbor;
    private CARule rule;
    private Random rand;
    private double concentrationWhenRandomized = 0.5;
    private double fitness;
    private double finalHs;
    private double goalOfFitness;
    private boolean optimized;

    public static String[] getInitTypeArray() {
        return InitTypeArray;
    }

    public CAConfig(CARule rule, boolean torus, boolean synchronous, int x_max, int y_max) {
        this.x_max = x_max;
        this.y_max = y_max;
        this.caState = new byte[x_max][y_max];
        this.initialize(rule, torus, synchronous);
    }

    public CAConfig(CARule rule, boolean torus, boolean synchronous, String filename) {
        this.caState = MyFileReader.loadCASnapshot(filename);
        this.x_max = this.caState.length;
        this.y_max = this.caState[0].length;
        this.initialize(rule, torus, synchronous);
    }

    public CAConfig(CARule rule, boolean torus, String InitType, boolean synchronous, int x_max, int y_max) {
        this(rule, torus, synchronous, x_max, y_max);
        if (InitType == null) {
            InitType = "random";
        }
        this.setInit(InitType);
    }

    private void initialize(CARule rule, boolean torus, boolean synchronous) {
        this.prevState = new byte[this.x_max][this.y_max];
        this.rule = rule;
        this.torus = torus;
        this.statePerCell = rule.getStatePerCell();
        this.synchronous = synchronous;
        if (!(rule instanceof PartitionIF)) {
            this.neighbor = rule instanceof LifeRule || rule instanceof Life2Rule || rule instanceof GenerationRule || rule instanceof HodgeRule || rule instanceof GMBrainRule || rule instanceof TransersRule || rule instanceof StarWarsRule || rule instanceof BrainRule ? new Moore(this.x_max, this.y_max) : new VonNeumann(this.x_max, this.y_max);
            this.neighbor.setTorus(torus);
        } else if (rule instanceof BlockVNRule) {
            this.partitionIn = new BlockVN(torus, this.x_max, this.y_max);
            this.partitionOut = new BlockVN(torus, this.x_max, this.y_max);
        } else if (rule instanceof Block4Rule) {
            this.partitionIn = new Margolus(torus, this.x_max, this.y_max);
            this.partitionOut = new Margolus(torus, this.x_max, this.y_max);
        } else if (rule instanceof Block9Rule) {
            this.partitionIn = new Block9(torus, this.x_max, this.y_max);
            this.partitionOut = new Block9(torus, this.x_max, this.y_max);
        } else if (rule instanceof CanonicalRule || rule instanceof CheckRule) {
            this.partitionIn = new Block16(torus, this.x_max, this.y_max);
            this.partitionOut = new Block16(torus, this.x_max, this.y_max);
        } else {
            this.partitionIn = new Partition(rule.getMaxNeighbor(), torus);
            this.partitionOut = new Partition(rule.getMaxNeighbor(), torus);
        }
        this.rand = new Random(System.currentTimeMillis());
    }

    @Override
    public void step() {
        if (this.synchronous) {
            this.synchronousUpdate();
        } else {
            this.asynchronousUpdate();
        }
    }

    private void synchronousUpdate() {
        int y;
        int x;
        for (x = 0; x < this.x_max; ++x) {
            for (y = 0; y < this.y_max; ++y) {
                this.prevState[x][y] = this.caState[x][y];
            }
        }
        for (x = 0; x < this.x_max; ++x) {
            for (y = 0; y < this.y_max; ++y) {
                this.neighbor.make(this.prevState, x, y);
                this.caState[x][y] = (byte)this.rule.output(this.neighbor);
            }
        }
    }

    private void asynchronousUpdate() {
        int x;
        int i;
        if (this.rule instanceof InteractingEnergy) {
            ((InteractingEnergy)((Object)this.rule)).updateDemon();
        }
        if (this.rule instanceof Dosable && this.rand.nextDouble() < ((Dosable)((Object)this.rule)).getDoseRate()) {
            int x2 = (int)Math.floor(this.rand.nextDouble() * (double)this.x_max);
            int y = (int)Math.floor(this.rand.nextDouble() * (double)this.y_max);
            this.caState[x2][y] = (byte)((this.caState[x2][y] + 1) % this.statePerCell);
        }
        if (this.rule instanceof PartitionIF) {
            for (i = 0; i < this.x_max * this.y_max; ++i) {
                x = (int)Math.floor(this.rand.nextDouble() * (double)this.x_max);
                int y = (int)Math.floor(this.rand.nextDouble() * (double)this.y_max);
                this.partitionIn.make(this.caState, x, y);
                this.partitionOut.setNeighborState(((PartitionIF)((Object)this.rule)).outputBlock(this.partitionIn).getNeighborState());
                this.partitionOut.updateCAState(this.caState, x, y);
            }
        } else {
            for (i = 0; i < this.x_max * this.y_max; ++i) {
                x = (int)Math.floor(this.rand.nextDouble() * (double)this.x_max);
                int y = (int)Math.floor(this.rand.nextDouble() * (double)this.y_max);
                this.neighbor.make(this.caState, x, y);
                this.caState[x][y] = (byte)this.rule.output(this.neighbor);
            }
        }
    }

    public void setInit(String InitType) {
        this.InitType = InitType;
        this.resetInit();
    }

    public String getInitType() {
        return this.InitType;
    }

    public double getConcentration() {
        return this.concentrationWhenRandomized;
    }

    private void resetInit() {
        if (this.InitType.regionMatches(true, 0, InitTypeArray[0], 0, 5)) {
            this.initNo = 0;
            String Density = MyString.stripBack(this.InitType, '_');
            if (Density != null) {
                try {
                    this.concentrationWhenRandomized = Double.valueOf(Density);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.randomize(this.concentrationWhenRandomized);
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[1], 0, 5)) {
            this.initNo = 1;
            this.letter_j();
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[2], 0, 5)) {
            this.initNo = 2;
            this.empty();
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[3], 0, 5)) {
            this.initNo = 3;
            this.single();
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[4], 0, 5)) {
            this.initNo = 4;
            this.square();
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[5], 0, 5)) {
            this.initNo = 5;
            this.cross();
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[6], 0, 5)) {
            this.initNo = 6;
            double[] dent = new double[this.statePerCell];
            for (int i = 0; i < this.statePerCell; ++i) {
                dent[i] = 1.0 / (double)this.statePerCell;
            }
            this.randomize(dent);
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[7], 0, 5)) {
            this.initNo = 7;
            this.srloop();
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[8], 0, 5)) {
            this.initNo = 8;
            this.checker();
        } else if (this.InitType.regionMatches(true, 0, InitTypeArray[9], 0, 5)) {
            this.initNo = 9;
            this.ground();
        } else {
            this.randomize(0.5);
            this.initNo = 0;
            System.out.println("InitConfig: No such InitType. ");
        }
    }

    public void empty() {
        for (int i = 0; i < this.x_max; ++i) {
            for (int j = 0; j < this.y_max; ++j) {
                this.caState[i][j] = 0;
            }
        }
    }

    public void letter_j() {
        this.empty();
        if (this.x_max < 20 | this.y_max < 20) {
            System.out.println("Cell space is too little for specified initial configuration");
        } else {
            int x_center = (int)Math.ceil((double)this.x_max / 2.0);
            int y_center = (int)Math.ceil((double)this.y_max / 2.0);
            this.caState[x_center - 2][y_center - 3] = 1;
            this.caState[x_center - 1][y_center - 3] = 1;
            this.caState[x_center][y_center - 3] = 1;
            this.caState[x_center + 1][y_center - 3] = 1;
            this.caState[x_center + 2][y_center - 3] = 1;
            this.caState[x_center][y_center - 2] = 1;
            this.caState[x_center][y_center - 1] = 1;
            this.caState[x_center][y_center] = 1;
            this.caState[x_center][y_center + 1] = 1;
            this.caState[x_center][y_center + 2] = 1;
            this.caState[x_center][y_center + 3] = 1;
            this.caState[x_center - 1][y_center + 3] = 1;
            this.caState[x_center - 2][y_center + 3] = 1;
            this.caState[x_center - 2][y_center + 2] = 1;
        }
    }

    public void single() {
        this.empty();
        if (this.x_max < 10 | this.y_max < 10) {
            System.out.println("Cell space is too little for specified initial configuration");
        } else {
            int x_center = (int)Math.ceil((double)this.x_max / 2.0);
            int y_center = (int)Math.ceil((double)this.y_max / 2.0);
            this.caState[x_center][y_center] = 1;
        }
    }

    public void square() {
        this.empty();
        if (this.x_max < 20 | this.y_max < 20) {
            System.out.println("Cell space is too little for specified initial configuration");
        } else {
            int x_center = (int)Math.ceil((double)this.x_max / 2.0);
            int y_center = (int)Math.ceil((double)this.y_max / 2.0);
            this.caState[x_center - 1][y_center - 1] = 1;
            this.caState[x_center - 1][y_center] = 1;
            this.caState[x_center - 1][y_center + 1] = 1;
            this.caState[x_center][y_center - 1] = 1;
            this.caState[x_center][y_center] = (byte)(this.statePerCell - 1);
            this.caState[x_center][y_center + 1] = 1;
            this.caState[x_center + 1][y_center - 1] = 1;
            this.caState[x_center + 1][y_center] = 1;
            this.caState[x_center + 1][y_center + 1] = 1;
        }
    }

    public void cross() {
        this.empty();
        if (this.x_max < 10 | this.y_max < 10) {
            System.out.println("Cell space is too little for specified initial configuration");
        } else {
            int x_center = (int)Math.ceil((double)this.x_max / 2.0);
            int y_center = (int)Math.ceil((double)this.y_max / 2.0);
            this.caState[x_center][y_center] = (byte)(this.statePerCell - 1);
            this.caState[x_center][y_center + 1] = 1;
            this.caState[x_center + 1][y_center] = 1;
            this.caState[x_center][y_center - 1] = (byte)(this.statePerCell - 1);
            this.caState[x_center - 1][y_center] = (byte)(this.statePerCell - 1);
        }
    }

    public void srloop() {
        int i;
        if (this.x_max < 100 | this.y_max < 100) {
            throw new IllegalArgumentException("Cell space is too little for specified initial configuration");
        }
        this.empty();
        int x_center = (int)Math.ceil((double)this.x_max / 2.0) - 5;
        int y_center = (int)Math.ceil((double)this.y_max / 2.0) - 4;
        for (i = 1; i < 9; ++i) {
            this.caState[x_center][y_center + i] = 2;
        }
        this.caState[x_center + 1][y_center] = 2;
        this.caState[x_center + 1][y_center + 1] = 1;
        this.caState[x_center + 1][y_center + 2] = 0;
        this.caState[x_center + 1][y_center + 3] = 7;
        this.caState[x_center + 1][y_center + 4] = 1;
        this.caState[x_center + 1][y_center + 5] = 0;
        this.caState[x_center + 1][y_center + 6] = 7;
        this.caState[x_center + 1][y_center + 7] = 1;
        this.caState[x_center + 1][y_center + 8] = 0;
        this.caState[x_center + 1][y_center + 9] = 2;
        for (i = 0; i < 10; ++i) {
            this.caState[x_center + 2][y_center + i] = 2;
        }
        this.caState[x_center + 2][y_center + 1] = 7;
        this.caState[x_center + 2][y_center + 8] = 7;
        this.caState[x_center + 3][y_center] = 2;
        this.caState[x_center + 3][y_center + 1] = 0;
        this.caState[x_center + 3][y_center + 2] = 2;
        this.caState[x_center + 3][y_center + 7] = 2;
        this.caState[x_center + 3][y_center + 8] = 1;
        this.caState[x_center + 3][y_center + 9] = 2;
        this.caState[x_center + 4][y_center] = 2;
        this.caState[x_center + 4][y_center + 1] = 1;
        this.caState[x_center + 4][y_center + 2] = 2;
        this.caState[x_center + 4][y_center + 7] = 2;
        this.caState[x_center + 4][y_center + 8] = 0;
        this.caState[x_center + 4][y_center + 9] = 2;
        this.caState[x_center + 5][y_center] = 2;
        this.caState[x_center + 5][y_center + 1] = 4;
        this.caState[x_center + 5][y_center + 2] = 2;
        this.caState[x_center + 5][y_center + 7] = 2;
        this.caState[x_center + 5][y_center + 8] = 7;
        this.caState[x_center + 5][y_center + 9] = 2;
        this.caState[x_center + 6][y_center] = 2;
        this.caState[x_center + 6][y_center + 1] = 0;
        this.caState[x_center + 6][y_center + 2] = 2;
        this.caState[x_center + 6][y_center + 7] = 2;
        this.caState[x_center + 6][y_center + 8] = 1;
        this.caState[x_center + 6][y_center + 9] = 2;
        for (i = 0; i < 10; ++i) {
            this.caState[x_center + 7][y_center + i] = 2;
        }
        this.caState[x_center + 7][y_center + 1] = 1;
        this.caState[x_center + 7][y_center + 8] = 0;
        this.caState[x_center + 8][y_center] = 2;
        this.caState[x_center + 8][y_center + 1] = 4;
        this.caState[x_center + 8][y_center + 2] = 0;
        this.caState[x_center + 8][y_center + 3] = 1;
        this.caState[x_center + 8][y_center + 4] = 1;
        this.caState[x_center + 8][y_center + 5] = 1;
        this.caState[x_center + 8][y_center + 6] = 1;
        this.caState[x_center + 8][y_center + 7] = 1;
        this.caState[x_center + 8][y_center + 8] = 7;
        this.caState[x_center + 8][y_center + 9] = 2;
        for (i = 1; i < 10; ++i) {
            this.caState[x_center + 9][y_center + i] = 2;
        }
        this.caState[x_center + 9][y_center + 8] = 1;
        for (i = 10; i < 14; ++i) {
            this.caState[x_center + i][y_center + 7] = 2;
            this.caState[x_center + i][y_center + 8] = 1;
            this.caState[x_center + i][y_center + 9] = 2;
        }
        this.caState[x_center + 14][y_center + 8] = 2;
    }

    public void checker() {
        boolean even1 = true;
        for (int i = 0; i < this.x_max; ++i) {
            even1 = !even1;
            boolean even2 = even1;
            for (int j = 0; j < this.y_max; ++j) {
                if (even2) {
                    this.caState[i][j] = 0;
                    even2 = false;
                    continue;
                }
                this.caState[i][j] = 1;
                even2 = true;
            }
        }
    }

    public void ground() {
        this.empty();
        int j = this.y_max - 1;
        for (int i = 0; i < this.x_max; ++i) {
            this.caState[i][j] = 1;
        }
    }

    public void setCAState(int state, int i, int j) {
        this.caState[i][j] = (byte)MyMath.mode(state, this.statePerCell);
    }

    @Override
    public boolean isTorus() {
        return this.torus;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    @Override
    public void setTorus(boolean torus) {
        this.torus = torus;
        this.neighbor.setTorus(torus);
    }

    public int getExcess() {
        if (this.statePerCell != 2) {
            throw new IllegalArgumentException("CAPicture: Invalid active state per cell");
        }
        int sum = 0;
        for (int x = 0; x < this.x_max; ++x) {
            for (int y = 0; y < this.y_max; ++y) {
                sum += 2 * this.caState[x][y] - 1;
            }
        }
        return sum;
    }

    public void randomize(double density) {
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.x_max; ++i) {
            for (int j = 0; j < this.y_max; ++j) {
                this.caState[i][j] = rand.nextDouble() < density ? (byte)(MyMath.irand(this.statePerCell - 1) + 1) : (byte)0;
            }
        }
    }

    public void randomize(double[] density) {
        if (density.length != this.statePerCell) {
            throw new IllegalArgumentException();
        }
        double[] sum = new double[this.statePerCell];
        for (int i = 0; i < this.statePerCell; ++i) {
            sum[i] = i == 0 ? density[i] : density[i] + sum[i - 1];
        }
        if (sum[this.statePerCell - 1] != 1.0) {
            throw new IllegalArgumentException();
        }
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.x_max; ++i) {
            for (int j = 0; j < this.y_max; ++j) {
                double ran = rand.nextDouble();
                int k = 0;
                while (ran > sum[k]) {
                    ++k;
                }
                this.caState[i][j] = (byte)k;
            }
        }
    }

    public Partition getVNNeighbor() {
        Partition vnNeighbor = new Partition(5);
        vnNeighbor.setTorus(this.torus);
        return vnNeighbor;
    }

    public Partition getVNNeighbor(int x, int y) {
        Partition vnNeighbor = new Partition(5);
        vnNeighbor.setTorus(this.torus);
        vnNeighbor.make(this.caState, x, y);
        return vnNeighbor;
    }

    public Partition getMoorNeighbor(int x, int y) {
        Partition moorNeighbor = new Partition(9);
        moorNeighbor.setTorus(this.torus);
        moorNeighbor.make(this.caState, x, y);
        return moorNeighbor;
    }

    public int getPopulation(int state) {
        int sum = 0;
        for (int x = 0; x < this.x_max; ++x) {
            for (int y = 0; y < this.y_max; ++y) {
                if (this.caState[x][y] != (byte)state) continue;
                ++sum;
            }
        }
        return sum;
    }

    public double getDensity() {
        return 1.0 - (double)this.getPopulation(0) / (double)(this.x_max * this.y_max);
    }

    public int getStatePerCell() {
        return this.statePerCell;
    }

    public boolean isEmptyState(int state) {
        return this.getPopulation(state) == 0;
    }

    @Override
    public byte[][] getCAState() {
        byte[][] caState = new byte[this.x_max][this.y_max];
        for (int i = 0; i < this.x_max; ++i) {
            for (int j = 0; j < this.y_max; ++j) {
                caState[i][j] = this.caState[i][j];
            }
        }
        return caState;
    }

    public byte getCAState(int i, int j) {
        return this.caState[i][j];
    }

    public int getXMax() {
        return this.x_max;
    }

    public int getYMax() {
        return this.y_max;
    }

    private boolean isRandom() {
        double entropy = EntroS.getEntro(this.caState, this.statePerCell);
        return entropy > 0.99;
    }

    @Override
    public CARule getCARule() {
        return this.rule;
    }

    @Override
    public double getFitness() {
        return this.fitness;
    }

    private synchronized void updateConvergedHs() {
        double currentHs;
        double dum;
        this.resetInit();
        if (!this.isRandom()) {
            throw new RuntimeException("Invalid initial condition.");
        }
        int t_max = 100;
        float[] Hs = CABatch.getHsWhileTransient(this, t_max);
        if (Hs.length >= t_max) {
            System.out.println("Transient time reached t_max.");
        }
        if ((dum = 1.0 / (currentHs = (double)Hs[Hs.length - 1]) - this.goalOfFitness) > 0.0) {
            this.optimized = true;
            if (Hs.length < 10) {
                throw new RuntimeException("Short transient optimized rule.");
            }
        }
        this.fitness = (double)Math.min(Hs.length, 10) / (currentHs * 10.0);
    }

    @Override
    public void updateFitness() {
        this.updateConvergedHs();
    }

    public void setFinalHs(double finalHs) {
        this.finalHs = finalHs;
        this.goalOfFitness = 1.0 / finalHs;
    }

    public double getFinalHs(double finalHs) {
        return finalHs;
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    @Override
    public void setGoalOfFitness(double goalOfFitness) {
        this.goalOfFitness = goalOfFitness;
    }
}

