/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.AquaRule;
import cambria.BlockOfCells;
import cambria.VonNeumann;

public class AquaP2Rule
extends AquaRule {
    private static final int statePerCell = 4;

    @Override
    public int output(BlockOfCells boc) {
        VonNeumann neighbor = (VonNeumann)boc;
        int threeTotal = neighbor.getNorthState() / 3 + neighbor.getEastState() / 3 + neighbor.getSouthState() / 3 + neighbor.getWestState() / 3;
        int oneTotal = neighbor.getNorthState() % 2 + neighbor.getEastState() % 2 + neighbor.getSouthState() % 2 + neighbor.getWestState() % 2 - threeTotal;
        int twoTotal = (neighbor.getNorthState() % 3 + neighbor.getEastState() % 3 + neighbor.getSouthState() % 3 + neighbor.getWestState() % 3 - oneTotal) / 2;
        int zeroTotal = 4 - threeTotal - twoTotal - oneTotal;
        int preyTotal = oneTotal;
        int predatorTotal = twoTotal + threeTotal;
        if (neighbor.getHomeState() == 0) {
            if (preyTotal == 0) {
                return 0;
            }
            if (predatorTotal == 0) {
                if (this.preyBornMap(preyTotal)) {
                    return 1;
                }
                return 0;
            }
            if (this.predatorBornMap(preyTotal, predatorTotal)) {
                return 3;
            }
            return 0;
        }
        if (neighbor.getHomeState() == 3) {
            if (preyTotal == 0) {
                return 0;
            }
            if (this.predatorSurviveMap(preyTotal, predatorTotal)) {
                return 2;
            }
            return 0;
        }
        if (neighbor.getHomeState() == 2) {
            if (preyTotal == 0) {
                return 3;
            }
            if (this.predatorSurviveMap(preyTotal, predatorTotal)) {
                return 2;
            }
            return 3;
        }
        if (predatorTotal == 0) {
            if (this.preySurviveMap(preyTotal)) {
                return 1;
            }
            return 0;
        }
        if (this.preyToPredatorMap(preyTotal, predatorTotal)) {
            return 2;
        }
        return 0;
    }

    @Override
    public int getStatePerCell() {
        return 4;
    }
}

