/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.ArrayList;
import java.util.List;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;

public class ToBinaryPlugin
extends ConverterPlugIn {
    private static final ILogger log = LoggerFactory.getLogger(ToBinaryPlugin.class);
    private List theConvertedSeries = new ArrayList();
    private double upperBit = 1.0;
    private double lowerBit = 0.0;

    public ToBinaryPlugin() {
    }

    public ToBinaryPlugin(String anAdvancedSerieSelector) {
        super(anAdvancedSerieSelector);
    }

    @Override
    protected boolean convert(int serie) {
        double[] myArray;
        int i;
        boolean retValue = false;
        int mySerie = serie;
        boolean myHasPositiveValues = false;
        boolean myHasNegativeValues = false;
        for (int i2 = 0; i2 < this.theConvertedSeries.size(); ++i2) {
            if (((int[])this.theConvertedSeries.get(i2))[0] >= serie) continue;
            mySerie += ((int[])this.theConvertedSeries.get(i2))[1];
        }
        int mySize = 0;
        double[][] myBinaries = new double[this.getInputVector().size()][];
        for (i = 0; i < this.getInputVector().size(); ++i) {
            myArray = ((Pattern)this.getInputVector().get(i)).getArray();
            myBinaries[i] = this.getBinary(myArray[mySerie]);
            if (myBinaries[i].length > mySize) {
                mySize = myBinaries[i].length;
            }
            if (myArray[mySerie] > 0.0) {
                myHasPositiveValues = true;
                continue;
            }
            if (!(myArray[mySerie] < 0.0)) continue;
            myHasNegativeValues = true;
        }
        int mySignBitLenght = myHasPositiveValues && myHasNegativeValues ? 1 : 0;
        for (i = 0; i < this.getInputVector().size(); ++i) {
            int j;
            myArray = ((Pattern)this.getInputVector().get(i)).getArray();
            double[] myNewArray = new double[myArray.length - 1 + mySize + mySignBitLenght];
            for (j = 0; j < myArray.length; ++j) {
                if (j < mySerie) {
                    myNewArray[j] = myArray[j];
                    continue;
                }
                if (j <= mySerie) continue;
                myNewArray[j + mySize + mySignBitLenght - 1] = myArray[j];
            }
            for (j = 0; j < mySize + mySignBitLenght; ++j) {
                if (j >= myBinaries[i].length) {
                    myNewArray[mySerie + j] = this.getLowerBit();
                    if (j != mySize || !(myArray[mySerie] < 0.0)) continue;
                    myNewArray[mySerie + j] = this.getUpperBit();
                    continue;
                }
                myNewArray[mySerie + j] = myBinaries[i][j];
            }
            ((Pattern)this.getInputVector().get(i)).setArray(myNewArray);
            retValue = true;
        }
        this.theConvertedSeries.add(new int[]{serie, mySize + mySignBitLenght - 1});
        return retValue;
    }

    @Override
    protected boolean apply() {
        this.theConvertedSeries = new ArrayList();
        return super.apply();
    }

    protected double[] getBinary(double aNumber) {
        aNumber = Math.floor(aNumber);
        double myTemp = aNumber = Math.abs(aNumber);
        int mySize = 0;
        while (myTemp > 0.0) {
            ++mySize;
            myTemp /= 2.0;
            myTemp = Math.floor(myTemp);
        }
        double[] myBinary = new double[mySize];
        for (int i = 0; i < mySize; ++i) {
            myTemp = aNumber / 2.0;
            myBinary[i] = myTemp > (aNumber = Math.floor(myTemp)) ? this.getUpperBit() : this.getLowerBit();
        }
        return myBinary;
    }

    public void setUpperBit(double aValue) {
        this.upperBit = aValue;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double aValue) {
        this.lowerBit = aValue;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }
}

