/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import org.joone.engine.Pattern;
import org.joone.util.ConverterPlugIn;

public class NormalizerPlugIn
extends ConverterPlugIn {
    private double min = 0.0;
    private double max = 1.0;
    private double datamin = 0.0;
    private double datamax = 0.0;
    private static final long serialVersionUID = 4662839350631576461L;

    @Override
    protected boolean convert(int serie) {
        double v;
        int i;
        double vMax;
        boolean retValue = false;
        int s = this.getInputVector().size();
        double vMin = vMax = this.getValuePoint(0, serie);
        if (this.datamin == 0.0 && this.datamax == 0.0) {
            for (i = 0; i < s; ++i) {
                v = this.getValuePoint(i, serie);
                if (v > vMax) {
                    vMax = v;
                    continue;
                }
                if (!(v < vMin)) continue;
                vMin = v;
            }
        } else {
            vMax = this.datamax;
            vMin = this.datamin;
        }
        double d = vMax - vMin;
        for (i = 0; i < s; ++i) {
            if (d != 0.0) {
                v = this.getValuePoint(i, serie);
                v = (v - vMin) / d;
                v = v * (this.getMax() - this.getMin()) + this.getMin();
            } else {
                v = this.getMin();
            }
            Pattern currPE = (Pattern)this.getInputVector().elementAt(i);
            currPE.setValue(serie, v);
            retValue = true;
        }
        return retValue;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double newMax) {
        if (this.max != newMax) {
            this.max = newMax;
            super.fireDataChanged();
        }
    }

    public void setMin(double newMin) {
        if (this.min != newMin) {
            this.min = newMin;
            super.fireDataChanged();
        }
    }

    public double getDataMax() {
        return this.datamax;
    }

    public double getDataMin() {
        return this.datamin;
    }

    public void setDataMax(double newDataMax) {
        if (this.datamax != newDataMax) {
            this.datamax = newDataMax;
            super.fireDataChanged();
        }
    }

    public void setDataMin(double newDataMin) {
        if (this.datamin != newDataMin) {
            this.datamin = newDataMin;
            super.fireDataChanged();
        }
    }
}

