/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import org.joone.engine.Monitor;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.MonitorPlugin;

public class DynamicAnnealing
extends MonitorPlugin {
    private static final ILogger log = LoggerFactory.getLogger(DynamicAnnealing.class);
    private double lastError = 0.0;
    private double step = 0.0;
    private static final long serialVersionUID = -5494365758818313237L;

    @Override
    protected void manageCycle(Monitor mon) {
        double actError = mon.getGlobalError();
        if (actError > this.lastError && this.lastError > 0.0 && this.step > 0.0) {
            double err = mon.getLearningRate() * (1.0 - this.step / 100.0);
            mon.setLearningRate(err);
            int currentCycle = mon.getTotCicles() - mon.getCurrentCicle() + 1;
            log.info("DynamicAnnealing: changed the learning rate to " + err + " at cycle n." + currentCycle);
        }
        this.lastError = actError;
    }

    @Override
    protected void manageStop(Monitor mon) {
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
        if (step >= 100.0) {
            this.step = 99.0;
        }
    }

    @Override
    protected void manageStart(Monitor mon) {
    }

    @Override
    protected void manageError(Monitor mon) {
    }

    @Override
    protected void manageStopError(Monitor mon, String msgErr) {
    }
}

