/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.joone.engine.DirectSynapse;
import org.joone.engine.Layer;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;

public class ImmediateEmbeddedXOR {
    private static final ILogger log = LoggerFactory.getLogger(ImmediateEmbeddedXOR.class);
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private static String xorNet = "org/joone/samples/engine/xor/xor.snet";

    public static void main(String[] args) {
        ImmediateEmbeddedXOR xor = new ImmediateEmbeddedXOR();
        xor.Go(xorNet);
    }

    private void Go(String fileName) {
        NeuralNet xor = this.restoreNeuralNet(fileName);
        if (xor != null) {
            Layer input = xor.getInputLayer();
            input.removeAllInputs();
            DirectSynapse memInp = new DirectSynapse();
            input.addInputSynapse(memInp);
            Layer output = xor.getOutputLayer();
            output.removeAllOutputs();
            DirectSynapse memOut = new DirectSynapse();
            output.addOutputSynapse(memOut);
            xor.getMonitor().setLearning(false);
            xor.go();
            log.debug("Network running: " + xor.isRunning());
            for (int n = 0; n < 100; ++n) {
                log.debug("Launch #" + n);
                for (int i = 0; i < 4; ++i) {
                    Pattern iPattern = new Pattern(this.inputArray[i]);
                    iPattern.setCount(i + 1);
                    memInp.fwdPut(iPattern);
                    Pattern pattern = memOut.fwdGet();
                    log.debug("Output Pattern #" + (i + 1) + " = " + pattern.getArray()[0]);
                }
            }
            Pattern stop = new Pattern(new double[2]);
            stop.setCount(-1);
            memInp.fwdPut(stop);
            memOut.fwdGet();
            log.debug("Network running: " + xor.isRunning());
            log.debug("Finished");
        }
    }

    private NeuralNet restoreNeuralNet(String fileName) {
        NeuralNet nnet = null;
        try {
            FileInputStream stream = new FileInputStream(fileName);
            ObjectInputStream input = new ObjectInputStream(stream);
            nnet = (NeuralNet)input.readObject();
        }
        catch (Exception e) {
            log.warn("Exception thrown while restoring the Neural Net. Message is : " + e.getMessage(), e);
        }
        return nnet;
    }
}

