/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.validation;

import java.util.Vector;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;

public class NeuralNetTrainer
implements Runnable,
NeuralNetListener,
NeuralValidationListener {
    private Vector listeners = new Vector();
    private NeuralNet nnet;
    private Thread myThread = null;

    public NeuralNetTrainer(NeuralNet nn) {
        this.nnet = this.cloneNet(nn);
    }

    public void addValidationListener(NeuralValidationListener newListener) {
        if (!this.listeners.contains(newListener)) {
            this.listeners.addElement(newListener);
        }
    }

    protected void train() {
        this.nnet.getMonitor().addNeuralNetListener(this);
        this.nnet.getMonitor().setLearning(true);
        this.nnet.getMonitor().setValidation(false);
        this.nnet.go(true);
        this.validate();
    }

    protected void validate() {
        NeuralNet newNet = this.cloneNet(this.nnet);
        NeuralNetValidator nnv = new NeuralNetValidator(newNet);
        nnv.addValidationListener(this);
        nnv.start();
    }

    private NeuralNet cloneNet(NeuralNet net) {
        net.getMonitor().setExporting(true);
        NeuralNet newNet = net.cloneNet();
        net.getMonitor().setExporting(false);
        newNet.removeAllListeners();
        return newNet;
    }

    private void fireNetValidated(NeuralValidationEvent event) {
        NeuralNet NN = (NeuralNet)event.getSource();
        NN.terminate(false);
        for (int i = 0; i < this.listeners.size(); ++i) {
            NeuralValidationListener nvl = (NeuralValidationListener)this.listeners.elementAt(i);
            nvl.netValidated(new NeuralValidationEvent(NN));
        }
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "Trainer");
            this.myThread.start();
        }
    }

    @Override
    public void run() {
        this.train();
        this.myThread = null;
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
    }

    @Override
    public void netValidated(NeuralValidationEvent event) {
        this.fireNetValidated(event);
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
        System.exit(1);
    }
}

