/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.scripting;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.joone.engine.FullSynapse;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.util.LearningSwitch;
import org.joone.util.MacroPlugin;
import org.joone.util.NormalizerPlugIn;

public class ScriptValidationSample {
    NeuralNet net;
    private static String filePath = "org/joone/samples/engine/scripting";

    public static void main(String[] args) {
        ScriptValidationSample sampleNet = new ScriptValidationSample();
        sampleNet.initialize(filePath);
        sampleNet.start();
    }

    private void initialize(String path) {
        LinearLayer ILayer = new LinearLayer();
        SigmoidLayer HLayer = new SigmoidLayer();
        SigmoidLayer OLayer = new SigmoidLayer();
        ILayer.setRows(13);
        HLayer.setRows(4);
        OLayer.setRows(1);
        FullSynapse synIH = new FullSynapse();
        FullSynapse synHO = new FullSynapse();
        this.connect(ILayer, synIH, HLayer);
        this.connect(HLayer, synHO, OLayer);
        FileInputSynapse ITdata = this.createInput(path + "/wine.txt", 1, 2, 14);
        FileInputSynapse IVdata = this.createInput(path + "/wine.txt", 131, 2, 14);
        FileInputSynapse DTdata = this.createInput(path + "/wine.txt", 1, 1, 1);
        FileInputSynapse DVdata = this.createInput(path + "/wine.txt", 131, 1, 1);
        LearningSwitch Ilsw = this.createSwitch(ITdata, IVdata);
        ILayer.addInputSynapse(Ilsw);
        LearningSwitch Dlsw = this.createSwitch(DTdata, DVdata);
        TeachingSynapse ts = new TeachingSynapse();
        ts.setDesired(Dlsw);
        OLayer.addOutputSynapse(ts);
        this.net = new NeuralNet();
        this.net.addLayer(ILayer, 0);
        this.net.addLayer(HLayer, 1);
        this.net.addLayer(OLayer, 2);
        this.net.setTeacher(ts);
        MacroPlugin mPlugin = new MacroPlugin();
        String validation = this.readFile(new File(path + "/validation.bsh"));
        mPlugin.getMacroManager().addMacro("cycleTerminated", validation);
        mPlugin.setRate(100);
        this.net.setMacroPlugin(mPlugin);
        this.net.setScriptingEnabled(true);
        Monitor mon = this.net.getMonitor();
        mon.setLearningRate(0.2);
        mon.setMomentum(0.3);
        mon.setTrainingPatterns(130);
        mon.setValidationPatterns(48);
        mon.setTotCicles(1000);
        mon.setLearning(true);
    }

    private FileInputSynapse createInput(String name, int firstRow, int firstCol, int lastCol) {
        FileInputSynapse input = new FileInputSynapse();
        input.setInputFile(new File(name));
        input.setFirstRow(firstRow);
        if (firstCol != lastCol) {
            input.setAdvancedColumnSelector(firstCol + "-" + lastCol);
        } else {
            input.setAdvancedColumnSelector(Integer.toString(firstCol));
        }
        NormalizerPlugIn norm = new NormalizerPlugIn();
        if (firstCol != lastCol) {
            norm.setAdvancedSerieSelector("1-" + Integer.toString(lastCol - firstCol + 1));
        } else {
            norm.setAdvancedSerieSelector("1");
        }
        input.addPlugIn(norm);
        return input;
    }

    private void connect(Layer ly1, Synapse syn, Layer ly2) {
        ly1.addOutputSynapse(syn);
        ly2.addInputSynapse(syn);
    }

    private LearningSwitch createSwitch(StreamInputSynapse IT, StreamInputSynapse IV) {
        LearningSwitch lsw = new LearningSwitch();
        lsw.addTrainingSet(IT);
        lsw.addValidationSet(IV);
        return lsw;
    }

    private String readFile(File p_file) {
        String str = null;
        FileReader reader = null;
        try {
            reader = new FileReader(p_file);
            int tch = new Long(p_file.length()).intValue();
            char[] m_buf = new char[tch];
            int nch = reader.read(m_buf);
            if (nch != -1) {
                str = new String(m_buf, 0, nch);
            }
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
            return str;
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        return str;
    }

    private void start() {
        this.net.go();
    }
}

